/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.neo4j.shell.parser.StatementParser;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ShellStatementParser
implements StatementParser {
    private static final char BACKSLASH = '\\';
    private static final String LINE_COMMENT_START = "//";
    private static final String LINE_COMMENT_END = "\n";
    private static final String BLOCK_COMMENT_START = "/*";
    private static final String BLOCK_COMMENT_END = "*/";
    private static final char BACKTICK = '`';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final Set<String> SINGLE_ARGUMENT_COMMANDS = Set.of(":param", ":params");

    @Override
    public StatementParser.ParsedStatements parse(Reader reader) throws IOException {
        return ShellStatementParser.parse(new PeekingReader(reader));
    }

    @Override
    public StatementParser.ParsedStatements parse(String line) throws IOException {
        return this.parse(new StringReader(line));
    }

    private static StatementParser.ParsedStatements parse(PeekingReader reader) throws IOException {
        int nextValue;
        ArrayList<StatementParser.ParsedStatement> result = new ArrayList<StatementParser.ParsedStatement>();
        while ((nextValue = reader.peek()) != -1) {
            if (ShellStatementParser.isWhitespace(nextValue)) {
                reader.read();
                continue;
            }
            if (ShellStatementParser.isAtStartOfComment(nextValue, reader)) {
                ShellStatementParser.skipComments(reader);
                continue;
            }
            if (nextValue == 58) {
                result.add(ShellStatementParser.parseCommand(reader));
                continue;
            }
            result.add(ShellStatementParser.parseCypher(reader));
        }
        return new StatementParser.ParsedStatements(result);
    }

    private static boolean isAtStartOfComment(int nextValue, PeekingReader reader) throws IOException {
        return nextValue == 47 && ShellStatementParser.isStartOfComment(reader.peek(2));
    }

    private static boolean isStartOfComment(char[] chars) {
        return switch (String.valueOf(chars)) {
            case LINE_COMMENT_START, BLOCK_COMMENT_START -> true;
            default -> false;
        };
    }

    private static void skipComments(PeekingReader reader) throws IOException {
        String awaitedRightDelimiter = ShellStatementParser.getRightCommentDelimiter(reader.peek(2));
        if (awaitedRightDelimiter == null) {
            return;
        }
        reader.read();
        reader.read();
        reader.skipUntilAndIncluding(awaitedRightDelimiter.toCharArray());
    }

    private static StatementParser.ParsedStatement parseCommand(PeekingReader reader) throws IOException {
        boolean isComplete;
        int startOffset = reader.offset();
        String line = reader.readWhile((CharPredicate & Serializable)c -> c != '\n' && c != '\r');
        int endOffset = reader.offset() - 1;
        assert (line.startsWith(":"));
        String[] parts = ShellStatementParser.stripTrailingSemicolons(line).split("\\s+");
        String name = parts[0];
        int nextChar = reader.peek();
        boolean bl = isComplete = nextChar == 10 || nextChar == 13;
        if (SINGLE_ARGUMENT_COMMANDS.contains(name)) {
            String arg = line.substring(name.length()).trim();
            return new StatementParser.CommandStatement(name, arg.isEmpty() ? List.of() : List.of(arg), isComplete, startOffset, endOffset);
        }
        return new StatementParser.CommandStatement(name, Arrays.stream(parts).skip(1L).toList(), isComplete, startOffset, endOffset);
    }

    private static String stripTrailingSemicolons(String input) {
        int i;
        for (i = input.length() - 1; i >= 0 && input.charAt(i) == ';'; --i) {
        }
        return input.substring(0, i + 1);
    }

    private static StatementParser.ParsedStatement parseCypher(PeekingReader reader) throws IOException {
        int read;
        int startOffset = reader.offset();
        String awaitedRightDelimiter = null;
        StringBuilder statement = new StringBuilder();
        boolean skipNext = false;
        char current = '\u0000';
        while ((read = reader.read()) != -1) {
            char previous = current;
            current = (char)read;
            statement.append(current);
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (ShellStatementParser.inComment(awaitedRightDelimiter)) {
                if (!ShellStatementParser.isRightDelimiter(awaitedRightDelimiter, previous, current)) continue;
                awaitedRightDelimiter = null;
                continue;
            }
            if (current == '\\') {
                skipNext = true;
                continue;
            }
            if (ShellStatementParser.inQuote(awaitedRightDelimiter)) {
                if (!ShellStatementParser.isRightDelimiter(awaitedRightDelimiter, previous, current)) continue;
                awaitedRightDelimiter = null;
                continue;
            }
            if (current == ';') {
                statement.setLength(statement.length() - 1);
                String cypherStatement = statement.toString();
                return new StatementParser.CypherStatement(cypherStatement, true, startOffset, reader.offset() - 2);
            }
            awaitedRightDelimiter = ShellStatementParser.getRightDelimiter(previous, current);
        }
        return new StatementParser.CypherStatement(statement.toString(), false, startOffset, reader.offset() - 1);
    }

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    private static boolean inQuote(String awaitedRightDelimiter) {
        return awaitedRightDelimiter != null && !ShellStatementParser.inComment(awaitedRightDelimiter);
    }

    private static boolean isRightDelimiter(String awaitedRightDelimiter, char first, char last) {
        if (awaitedRightDelimiter == null) {
            return false;
        }
        if (awaitedRightDelimiter.length() == 1) {
            return awaitedRightDelimiter.charAt(0) == last;
        }
        if (awaitedRightDelimiter.length() == 2) {
            return awaitedRightDelimiter.charAt(0) == first && awaitedRightDelimiter.charAt(1) == last;
        }
        return false;
    }

    private static boolean inComment(String awaitedRightDelimiter) {
        return LINE_COMMENT_END.equals(awaitedRightDelimiter) || BLOCK_COMMENT_END.equals(awaitedRightDelimiter);
    }

    private static String getRightDelimiter(char first, char last) {
        String commentRight = ShellStatementParser.getRightCommentDelimiter(new char[]{first, last});
        return commentRight != null ? commentRight : ShellStatementParser.getRightQuoteDelimiter(last);
    }

    private static String getRightCommentDelimiter(char[] chars) {
        return switch (String.valueOf(chars)) {
            case LINE_COMMENT_START -> LINE_COMMENT_END;
            case BLOCK_COMMENT_START -> BLOCK_COMMENT_END;
            default -> null;
        };
    }

    private static String getRightQuoteDelimiter(char last) {
        return switch (last) {
            case '\"', '\'', '`' -> String.valueOf(last);
            default -> null;
        };
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PeekingReader {
        private final BufferedReader reader;
        private int offset;

        PeekingReader(Reader reader) {
            BufferedReader buffered;
            this.reader = reader instanceof BufferedReader ? (buffered = (BufferedReader)reader) : new BufferedReader(reader);
        }

        public int read() throws IOException {
            int read = this.reader.read();
            if (read != -1) {
                ++this.offset;
            }
            return read;
        }

        public int peek() throws IOException {
            this.reader.mark(1);
            int value = this.reader.read();
            this.reader.reset();
            return value;
        }

        public char[] peek(int size) throws IOException {
            this.reader.mark(size);
            char[] values = new char[size];
            for (int i = 0; i < size; ++i) {
                int read = this.reader.read();
                if (read == -1) {
                    this.reader.reset();
                    return Arrays.copyOf(values, i);
                }
                values[i] = (char)read;
            }
            this.reader.reset();
            return values;
        }

        public void skipUntilAndIncluding(char[] chars) throws IOException {
            int read;
            int matches = 0;
            while ((read = this.read()) != -1) {
                if (read == chars[matches]) {
                    if (++matches != chars.length) continue;
                    return;
                }
                if (matches == 0) continue;
                matches = 0;
            }
        }

        public String readWhile(CharPredicate predicate) throws IOException {
            int peek;
            StringBuilder line = new StringBuilder();
            while ((peek = this.peek()) != -1) {
                if (predicate.accept((char)peek)) {
                    line.append((char)this.read());
                    continue;
                }
                return line.toString();
            }
            return line.toString();
        }

        public int offset() {
            return this.offset;
        }
    }
}

