/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.log;

import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.log.ShellLogger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface Logger {
    public void info(String var1);

    public void info(String var1, Throwable var2);

    public void warn(String var1, Throwable var2);

    public void warn(Throwable var1);

    public void error(String var1, Throwable var2);

    public void error(Throwable var1);

    public static Logger create() {
        return ShellLogger.INSTANCE;
    }

    public static void setupLogging(CliArgs args) {
        args.logHandler().ifPresentOrElse(Logger::setupLogging, Logger::disableLogging);
    }

    private static void setupLogging(Handler handler) {
        Logger.disableLogging();
        java.util.logging.Level level = java.util.logging.Level.ALL;
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$-6s %2$s %5$s%6$s%n");
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setLevel(level);
        handler.setLevel(level);
        handler.setFormatter(new SimpleFormatter());
        rootLogger.addHandler(handler);
    }

    private static void disableLogging() {
        java.util.logging.Logger.getLogger("org.jline").setLevel(java.util.logging.Level.OFF);
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setLevel(java.util.logging.Level.OFF);
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(java.util.logging.Level.OFF);
            rootLogger.removeHandler(h);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Level {
        ERROR(java.util.logging.Level.SEVERE),
        WARNING(java.util.logging.Level.WARNING),
        INFO(java.util.logging.Level.INFO),
        DEBUG(java.util.logging.Level.FINE),
        ALL(java.util.logging.Level.ALL),
        OFF(java.util.logging.Level.OFF);

        private final java.util.logging.Level javaLevel;

        private Level(java.util.logging.Level javaLevel) {
            this.javaLevel = javaLevel;
        }

        public java.util.logging.Level javaLevel() {
            return this.javaLevel;
        }

        public static Level from(String value) {
            return Level.valueOf(value.toUpperCase());
        }

        public static Level defaultActiveLevel() {
            return DEBUG;
        }
    }
}

