/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.util;

import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.shell.util.Version;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Versions {
    private Versions() {
        throw new UnsupportedOperationException("Don't instantiate");
    }

    public static int majorVersion(String version) throws FailedToParseException {
        return Versions.version(version).major();
    }

    public static int minorVersion(String version) throws FailedToParseException {
        return Versions.version(version).minor();
    }

    public static int patch(String version) throws FailedToParseException {
        return Versions.version(version).patch();
    }

    public static Version version(String version) throws FailedToParseException {
        if (version == null) {
            throw new FailedToParseException("null is not a valid version string");
        }
        if (version.isEmpty()) {
            return new Version(0, 0, 0);
        }
        int offset = version.indexOf("-");
        if (offset > 0) {
            version = version.substring(0, offset);
        }
        String[] split = version.split("\\.");
        try {
            return switch (split.length) {
                case 1 -> new Version(Integer.parseInt(split[0]), 0, 0);
                case 2 -> new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]), 0);
                case 3 -> new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                default -> throw new FailedToParseException(String.format("%s is not a proper version string, it should be of the form X.Y.Z ", version));
            };
        }
        catch (NumberFormatException e) {
            throw new FailedToParseException(String.format("%s is not a proper version string, it should be of the form X.Y.Z ", version));
        }
    }

    public static boolean isPasswordChangeRequiredException(Neo4jException e) {
        return "Neo.ClientError.Security.CredentialsExpired".equalsIgnoreCase(e.code());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class FailedToParseException
    extends Exception {
        public FailedToParseException(String message) {
            super(message);
        }
    }
}

