/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.commands.ClientConfig;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.Metric;
import org.neo4j.shell.commands.MetricGroup;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.prettyprint.TableOutputFormatter;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.util.Version;
import org.neo4j.shell.util.Versions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SysInfo
implements Command {
    private final Printer printer;
    private final TableOutputFormatter tableFormatter;
    private final CypherShell shell;
    private final Version firstSupportedVersion = new Version(4, 4, 0);
    private final String SYSTEM_DB_TYPE = "system";
    private final String COMPOSITE_DB_TYPE = "composite";
    final List<MetricGroup> allMetrics = List.of(new MetricGroup("ID Allocation", List.of(Metric.db("ids_in_use.property", "Property ID"), Metric.db("ids_in_use.relationship", "Relationship ID"), Metric.db("ids_in_use.relationship_type", "Relationship Type ID"))), new MetricGroup("Store Size", List.of(Metric.db("store.size.total", "Total"), Metric.db("store.size.database", "Database"))), new MetricGroup("Page Cache", List.of(Metric.dbms("page_cache.hits", "Hits"), Metric.dbms("page_cache.hit_ratio", "Hit Ratio"), Metric.dbms("page_cache.usage_ratio", "Usage Ratio"), Metric.dbms("page_cache.page_faults", "Page Faults"))), new MetricGroup("Transactions", List.of(Metric.db("transaction.last_committed_tx_id", "Last Tx Id"), Metric.db("transaction.active_read", "Current Read"), Metric.db("transaction.active_write", "Current Write"), Metric.db("transaction.peak_concurrent", "Peak Transactions"), Metric.db("transaction.committed_read", "Committed Read"), Metric.db("transaction.committed_write", "Committed Write"))));

    public SysInfo(Printer printer, CypherShell shell) {
        this.printer = printer;
        this.tableFormatter = new TableOutputFormatter(false, 100);
        this.shell = shell;
    }

    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0);
        if (!this.shell.isConnected()) {
            throw new CommandException("Connect to a database to use :sysinfo");
        }
        if (!this.isSupportedVersion()) {
            throw new CommandException(":sysinfo is only supported since " + this.firstSupportedVersion);
        }
        if (this.isSystemOrCompositeDb()) {
            throw new CommandException("The :sysinfo command is not supported while using the system or a composite database.");
        }
        ClientConfig clientConfig = this.clientConfig();
        String db = this.shell.getActualDatabaseAsReportedByServer();
        this.printDatabases();
        for (MetricGroup group : this.allMetrics) {
            this.printMetrics(clientConfig, db, group);
        }
    }

    private boolean isSupportedVersion() {
        String version = this.shell.getServerVersion();
        try {
            return version == null || version.isBlank() || Versions.version(version).compareTo(this.firstSupportedVersion) >= 0;
        }
        catch (Versions.FailedToParseException e) {
            return true;
        }
    }

    private boolean isSystemOrCompositeDb() throws CommandException {
        String dbName = this.shell.getActualDatabaseAsReportedByServer();
        String query = "SHOW DATABASES WHERE name = $db";
        Optional<BoltResult> result = this.shell.runCypher("SHOW DATABASES WHERE name = $db", Map.of("db", Values.value((String)dbName)), TransactionHandler.TransactionType.USER_ACTION);
        if (result.isPresent()) {
            for (Record record : result.get().getRecords()) {
                String dbType = record.get("type").asString("");
                if (!"system".equals(dbType) && !"composite".equals(dbType) && (!dbType.isEmpty() || !"system".equals(dbName))) continue;
                return true;
            }
        }
        return false;
    }

    private ClientConfig clientConfig() throws CommandException {
        Map clientConfigMap = this.shell.runCypher("CALL dbms.clientConfig() yield name, value", Map.of(), TransactionHandler.TransactionType.USER_ACTION).map(result -> result.getRecords().stream().collect(Collectors.toMap(r -> r.get("name").asString(), r -> r.get("value").asString()))).orElseGet(Map::of);
        String serverMetricsPrefix = Optional.ofNullable((String)clientConfigMap.get("server.metrics.prefix")).or(() -> Optional.ofNullable((String)clientConfigMap.get("metrics.prefix"))).orElse("neo4j");
        Optional<Boolean> namespacesEnabled = Optional.ofNullable((String)clientConfigMap.get("metrics.namespaces.enabled")).map("true"::equals);
        return new ClientConfig(serverMetricsPrefix, namespacesEnabled);
    }

    private void printDatabases() throws CommandException {
        String query = "SHOW DATABASES YIELD\n  name AS Name,\n  address AS Address,\n  role AS Role,\n  currentStatus AS Status,\n  default AS Default";
        this.shell.runCypher("SHOW DATABASES YIELD\n  name AS Name,\n  address AS Address,\n  role AS Role,\n  currentStatus AS Status,\n  default AS Default", Map.of(), TransactionHandler.TransactionType.USER_ACTION).ifPresent(result -> {
            this.printer.printOut("");
            this.tableFormatter.formatWithHeading((BoltResult)result, this.printer, "Databases");
        });
    }

    private void printMetrics(ClientConfig config, String database, MetricGroup group) throws CommandException {
        String query = "UNWIND $metrics as metric\nCALL dbms.queryJmx(metric.name) YIELD name, attributes\nWITH metric.displayName AS Name, attributes.Value.value AS value, attributes.Count.value AS count\nRETURN\n  Name,\n  CASE WHEN value IS NOT NULL then value ELSE count END AS Value";
        List<Map> metricNamesParam = group.metrics().stream().map(m -> Map.of("name", m.fullName(config, database), "displayName", m.displayName())).toList();
        Map<String, Value> params = Map.of("metrics", Values.value(metricNamesParam));
        this.shell.runCypher("UNWIND $metrics as metric\nCALL dbms.queryJmx(metric.name) YIELD name, attributes\nWITH metric.displayName AS Name, attributes.Value.value AS value, attributes.Count.value AS count\nRETURN\n  Name,\n  CASE WHEN value IS NOT NULL then value ELSE count END AS Value", params, TransactionHandler.TransactionType.USER_ACTION).ifPresent(result -> {
            this.printer.printOut("");
            this.tableFormatter.formatWithHeading((BoltResult)result, this.printer, group.name());
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "':sysinfo' prints neo4j system information";
            return new Command.Metadata(":sysinfo", "Neo4j system information", "", help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new SysInfo(args.printer(), args.cypherShell());
        }
    }
}

