/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Historian;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.terminal.CypherShellTerminal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface Command {
    public void execute(List<String> var1) throws ExitException, CommandException;

    default public Metadata metadata() {
        return new CommandHelper.CommandFactoryHelper().factoryFor(this.getClass()).metadata();
    }

    default public void requireArgumentCount(List<String> args, int count) throws CommandException {
        if (args.size() != count) {
            throw new CommandException(this.incorrectNumberOfArguments());
        }
    }

    default public void requireArgumentCount(List<String> args, int min, int max) throws CommandException {
        if (args.size() < min || args.size() > max) {
            throw new CommandException(this.incorrectNumberOfArguments());
        }
    }

    default public AnsiFormattedText incorrectNumberOfArguments() {
        return AnsiFormattedText.from("Incorrect number of arguments.\nUsage: ").bold(this.metadata().name()).append(" ").append(this.metadata().usage());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Factory {
        public Metadata metadata();

        public Command executor(Arguments var1);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public record Arguments(Printer printer, Historian historian, CypherShell cypherShell, CypherShellTerminal terminal, ParameterService parameters) {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Metadata(String name, String description, String usage, String help, List<String> aliases) {
    }
}

