/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.neo4j.shell.parameter.ParameterService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AddParamArgumentAction
implements ArgumentAction {
    private final ParameterService.ParameterParser queryParameterParser;

    AddParamArgumentAction(ParameterService.ParameterParser queryParameterParser) {
        this.queryParameterParser = queryParameterParser;
    }

    public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value) throws ArgumentParserException {
        Object object = attrs.get(arg.getDest());
        if (object instanceof List) {
            List queryParams = (List)object;
            queryParams.add(this.parse(value.toString()));
        } else {
            ArrayList<ParameterService.RawParameters> queryParams = new ArrayList<ParameterService.RawParameters>();
            queryParams.add(this.parse(value.toString()));
            attrs.put(arg.getDest(), queryParams);
        }
    }

    private ParameterService.RawParameters parse(String input) {
        try {
            return this.queryParameterParser.parse(input);
        }
        catch (ParameterService.ParameterParsingException e) {
            throw new IllegalArgumentException("Incorrect usage.\nusage: --param  'name => value'");
        }
    }

    public void onAttach(Argument arg) {
    }

    public boolean consumeArgument() {
        return true;
    }
}

