/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.util.function.Supplier;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.Expander;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Macro;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Attributes;
import org.jline.terminal.TerminalBuilder;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.parser.CypherLanguageService;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.JlineCompleter;
import org.neo4j.shell.terminal.JlineTerminal;
import org.neo4j.shell.terminal.SimplePrompt;
import org.neo4j.shell.terminal.StatementJlineParser;
import org.neo4j.shell.terminal.WriteOnlyCypherShellTerminal;
import org.neo4j.util.VisibleForTesting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CypherShellTerminalBuilder {
    private static final Logger log = Logger.create();
    private Printer printer;
    private OutputStream out;
    private InputStream in;
    private boolean isInteractive = true;
    private boolean dumb;
    private ParameterService parameters;
    private Supplier<SimplePrompt> simplePromptSupplier = SimplePrompt::defaultPrompt;
    private boolean enableCypherCompletion = false;
    private Duration idleTimeout;
    private Duration idleDelay;

    public CypherShellTerminalBuilder interactive(boolean isInteractive) {
        this.isInteractive = isInteractive;
        return this;
    }

    public CypherShellTerminalBuilder logger(Printer printer) {
        this.printer = printer;
        return this;
    }

    public CypherShellTerminalBuilder parameters(ParameterService parameters) {
        this.parameters = parameters;
        return this;
    }

    public CypherShellTerminalBuilder idleTimeout(Duration idleTimeout, Duration delay) {
        this.idleTimeout = idleTimeout;
        this.idleDelay = delay;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder dumb() {
        this.dumb = true;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder simplePromptSupplier(Supplier<SimplePrompt> simplePromptSupplier) {
        this.simplePromptSupplier = simplePromptSupplier;
        return this;
    }

    public CypherShellTerminalBuilder enableCypherCompletion(boolean enable) {
        this.enableCypherCompletion = enable;
        return this;
    }

    public CypherShellTerminal build() {
        assert (this.printer != null);
        try {
            return this.isInteractive ? this.buildJlineBasedTerminal() : this.nonInteractiveTerminal();
        }
        catch (IOException e) {
            log.warn("Fallback to non-interactive mode", e);
            if (this.isInteractive) {
                this.printer.printError("Failed to create interactive terminal, fallback to non-interactive mode");
            }
            return this.nonInteractiveTerminal();
        }
    }

    private CypherShellTerminal nonInteractiveTerminal() {
        return new WriteOnlyCypherShellTerminal(this.out != null ? new PrintStream(this.out) : System.out);
    }

    public CypherShellTerminal buildJlineBasedTerminal() throws IOException {
        TerminalBuilder jLineTerminal = TerminalBuilder.builder();
        jLineTerminal.nativeSignals(true);
        jLineTerminal.paused(true);
        if (this.in != null) {
            jLineTerminal.streams(this.in, this.out);
        }
        if (this.dumb) {
            Attributes attributes = new Attributes();
            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, false);
            jLineTerminal.jna(false).jansi(false);
            jLineTerminal.dumb(true).type("dumb").attributes(attributes);
        }
        CypherLanguageService cypherLangService = CypherLanguageService.get();
        LineReader reader = LineReaderBuilder.builder().terminal(jLineTerminal.build()).parser((Parser)new StatementJlineParser(new ShellStatementParser(), cypherLangService)).completer((Completer)new JlineCompleter(new CommandHelper.CommandFactoryHelper(), cypherLangService, this.parameters, this.enableCypherCompletion)).history((History)new DefaultHistory()).expander((Expander)new JlineTerminal.EmptyExpander()).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.DISABLE_HIGHLIGHTER, true).option(LineReader.Option.CASE_INSENSITIVE, true).appName("Cypher Shell").build();
        CypherShellTerminalBuilder.bindKeyPadKeys(reader);
        return new JlineTerminal(reader, this.isInteractive, this.printer, this.simplePromptSupplier, this.idleTimeout, this.idleDelay);
    }

    public static CypherShellTerminalBuilder terminalBuilder() {
        return new CypherShellTerminalBuilder();
    }

    private static void bindKeyPadKeys(LineReader lineReader) {
        KeyMap keyMap = (KeyMap)lineReader.getKeyMaps().get("main");
        keyMap.bind((Object)new Macro(KeyMap.translate((String)".")), (CharSequence)KeyMap.translate((String)"^[On"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"^M")), (CharSequence)KeyMap.translate((String)"^[OM"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"0")), (CharSequence)KeyMap.translate((String)"^[Op"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"1")), (CharSequence)KeyMap.translate((String)"^[Oq"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"2")), (CharSequence)KeyMap.translate((String)"^[Or"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"3")), (CharSequence)KeyMap.translate((String)"^[Os"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"4")), (CharSequence)KeyMap.translate((String)"^[Ot"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"5")), (CharSequence)KeyMap.translate((String)"^[Ou"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"6")), (CharSequence)KeyMap.translate((String)"^[Ov"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"7")), (CharSequence)KeyMap.translate((String)"^[Ow"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"8")), (CharSequence)KeyMap.translate((String)"^[Ox"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"9")), (CharSequence)KeyMap.translate((String)"^[Oy"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"+")), (CharSequence)KeyMap.translate((String)"^[Ol"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"-")), (CharSequence)KeyMap.translate((String)"^[OS"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"*")), (CharSequence)KeyMap.translate((String)"^[OR"));
        keyMap.bind((Object)new Macro(KeyMap.translate((String)"/")), (CharSequence)KeyMap.translate((String)"^[OQ"));
        keyMap.bind((Object)new Reference("beginning-of-line"), (CharSequence)KeyMap.translate((String)"\u001b[1~"));
        keyMap.bind((Object)new Reference("end-of-line"), (CharSequence)KeyMap.translate((String)"\u001b[4~"));
    }
}

