/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Connector;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.cli.AccessMode;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.prettyprint.PrettyPrinter;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.state.BoltStateHandler;
import org.neo4j.shell.state.LicenseDetails;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CypherShell
implements StatementExecuter,
Connector,
TransactionHandler,
DatabaseManager {
    private static final Logger log = Logger.create();
    private static final String LICENSE_EXPIRED_WARNING = "Thank you for installing Neo4j. This is a time limited trial, and the\n%d days have expired. Please contact https://neo4j.com/contact-us/\nto continue using the software. Use of this Software without\na proper commercial or evaluation license with Neo4j, Inc. or\nits affiliates is prohibited.\n";
    private static final String LICENSE_DAYS_LEFT_WARNING = "Thank you for installing Neo4j. This is a time limited trial.\nYou have %d days remaining out of %d days. Please\ncontact https://neo4j.com/contact-us/ if you require more time.\n";
    private static final String LICENSE_NOT_ACCEPTED_WARNING = "A Neo4j license has not been accepted. To accept the commercial license agreement, run\n    neo4j-admin server license --accept-commercial.\nTo accept the terms of the evaluation agreement, run\n    neo4j-admin server license --accept-evaluation.\n\n(c) Neo4j Sweden AB. All Rights Reserved.\nUse of this Software without a proper commercial license, or evaluation license\nwith Neo4j, Inc. or its affiliates is prohibited.\nNeo4j has the right to terminate your usage if you are not compliant.\n\nPlease contact us about licensing via https://neo4j.com/contact-us/\n";
    private final ParameterService parameters;
    private final Printer printer;
    private final BoltStateHandler boltStateHandler;
    private final PrettyPrinter prettyPrinter;
    private CommandHelper commandHelper;
    private String lastNeo4jErrorCode;

    public CypherShell(Printer printer, BoltStateHandler boltStateHandler, PrettyPrinter prettyPrinter, ParameterService parameters) {
        this.printer = printer;
        this.boltStateHandler = boltStateHandler;
        this.prettyPrinter = prettyPrinter;
        this.parameters = parameters;
        this.addRuntimeHookToResetShell();
    }

    @Override
    public void execute(StatementParser.ParsedStatement statement) throws ExitException, CommandException {
        if (statement instanceof StatementParser.CommandStatement) {
            StatementParser.CommandStatement commandStatement = (StatementParser.CommandStatement)statement;
            this.executeCommand(commandStatement);
        } else if (!statement.statement().isBlank()) {
            this.executeCypher(statement.statement());
        }
    }

    @Override
    public void execute(List<StatementParser.ParsedStatement> statements) throws ExitException, CommandException {
        for (StatementParser.ParsedStatement statement : statements) {
            this.execute(statement);
        }
    }

    @Override
    public String lastNeo4jErrorCode() {
        return this.lastNeo4jErrorCode;
    }

    private void executeCypher(String cypher) throws CommandException {
        log.info("Executing cypher: " + cypher);
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        try {
            Optional<BoltResult> result = this.boltStateHandler.runUserCypher(cypher, this.parameters.parameters());
            result.ifPresent(boltResult -> {
                this.prettyPrinter.format((BoltResult)boltResult, this.printer);
                this.boltStateHandler.updateActualDbName(boltResult.getSummary());
            });
            this.lastNeo4jErrorCode = null;
        }
        catch (Neo4jException e) {
            log.error(e);
            this.lastNeo4jErrorCode = CypherShell.getErrorCode(e);
            throw this.boltStateHandler.handleException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.boltStateHandler.isConnected();
    }

    private void executeCommand(StatementParser.CommandStatement statement) throws CommandException {
        log.info("Executing command: " + statement.statement());
        Command command = this.commandHelper.getCommand(statement.name());
        if (command == null) {
            throw new CommandException("Could not find command " + statement.name() + ", use :help to see available commands");
        }
        command.execute(statement.args());
    }

    @Override
    public void connect(ConnectionConfig connectionConfig) throws CommandException {
        this.boltStateHandler.connect(connectionConfig);
    }

    @Override
    public void connect(String user, String password, String database) throws CommandException {
        this.boltStateHandler.connect(user, password, database);
    }

    @Override
    public void impersonate(String impersonatedUser) throws CommandException {
        this.boltStateHandler.impersonate(impersonatedUser);
    }

    @Override
    public void reconnect() throws CommandException {
        this.boltStateHandler.reconnect();
    }

    @Override
    public void reconnect(AccessMode accessMode) throws CommandException {
        this.boltStateHandler.reconnect(accessMode);
    }

    @Override
    public String getServerVersion() {
        return this.boltStateHandler.getServerVersion();
    }

    @Override
    public String getProtocolVersion() {
        return this.boltStateHandler.getProtocolVersion();
    }

    @Override
    public String username() {
        return this.boltStateHandler.username();
    }

    @Override
    public ConnectionConfig connectionConfig() {
        return this.boltStateHandler.connectionConfig();
    }

    @Override
    public Optional<String> impersonatedUser() {
        return this.boltStateHandler.impersonatedUser();
    }

    @Override
    public void beginTransaction() throws CommandException {
        this.boltStateHandler.beginTransaction();
    }

    @Override
    public void commitTransaction() throws CommandException {
        try {
            this.boltStateHandler.commitTransaction();
            this.lastNeo4jErrorCode = null;
        }
        catch (Neo4jException e) {
            log.error(e);
            this.lastNeo4jErrorCode = CypherShell.getErrorCode(e);
            throw e;
        }
    }

    @Override
    public void rollbackTransaction() throws CommandException {
        this.boltStateHandler.rollbackTransaction();
    }

    @Override
    public boolean isTransactionOpen() {
        return this.boltStateHandler.isTransactionOpen();
    }

    @Override
    public Optional<BoltResult> runUserCypher(String cypher, Map<String, Value> queryParams) throws CommandException {
        return this.boltStateHandler.runUserCypher(cypher, queryParams);
    }

    @Override
    public Optional<BoltResult> runCypher(String cypher, Map<String, Value> queryParams, TransactionHandler.TransactionType type) throws CommandException {
        return this.boltStateHandler.runCypher(cypher, queryParams, type);
    }

    public void setCommandHelper(CommandHelper commandHelper) {
        this.commandHelper = commandHelper;
    }

    @Override
    public void reset() {
        this.boltStateHandler.reset();
    }

    protected void addRuntimeHookToResetShell() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::reset));
    }

    @Override
    public void setActiveDatabase(String databaseName) throws CommandException {
        try {
            this.boltStateHandler.setActiveDatabase(databaseName);
            this.lastNeo4jErrorCode = null;
        }
        catch (Neo4jException e) {
            log.error(e);
            this.lastNeo4jErrorCode = CypherShell.getErrorCode(e);
            throw e;
        }
    }

    @Override
    public String getActiveDatabaseAsSetByUser() {
        return this.boltStateHandler.getActiveDatabaseAsSetByUser();
    }

    @Override
    public String getActualDatabaseAsReportedByServer() {
        return this.boltStateHandler.getActualDatabaseAsReportedByServer();
    }

    public void changePassword(ConnectionConfig connectionConfig, String newPassword) {
        this.boltStateHandler.changePassword(connectionConfig, newPassword);
    }

    @Override
    public void disconnect() {
        this.boltStateHandler.disconnect();
    }

    private static String getErrorCode(Neo4jException e) {
        Throwable[] suppressed;
        Neo4jException statusException = e;
        for (Throwable s : suppressed = e.getSuppressed()) {
            if (!(s instanceof Neo4jException)) continue;
            statusException = (Neo4jException)s;
            break;
        }
        if (statusException instanceof ServiceUnavailableException || statusException instanceof DiscoveryException) {
            return "Neo.TransientError.General.DatabaseUnavailable";
        }
        return statusException.code();
    }

    public void printFallbackWarning(URI originalUri) {
        URI newUri = this.connectionConfig().uri();
        if (!newUri.equals(originalUri)) {
            String fallbackWarning = String.format("Failed to connect to %s, fallback to %s", originalUri, newUri);
            this.printer.printIfVerbose(AnsiFormattedText.s().orange(fallbackWarning).resetAndRender());
        }
    }

    public void printLicenseWarnings() {
        LicenseDetails license = this.boltStateHandler.licenseDetails();
        if (license.status() == LicenseDetails.Status.NO) {
            this.printer.printOut(AnsiFormattedText.s().orange(String.format(LICENSE_NOT_ACCEPTED_WARNING, new Object[0])).resetAndRender());
        } else if (license.status() == LicenseDetails.Status.EXPIRED && license.trialDays().isPresent()) {
            this.printer.printOut(AnsiFormattedText.s().orange(String.format(LICENSE_EXPIRED_WARNING, license.trialDays().get())).resetAndRender());
        } else if (license.status() == LicenseDetails.Status.EVAL && license.daysLeft().isPresent() && license.trialDays().isPresent()) {
            this.printer.printOut(String.format(LICENSE_DAYS_LEFT_WARNING, license.daysLeft().get(), license.trialDays().get()));
        }
    }

    public AccessMode accessMode() {
        return this.boltStateHandler.accessMode();
    }
}

