/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NonInteractiveShellRunner
implements ShellRunner {
    private static final Logger log = Logger.create();
    private final FailBehavior failBehavior;
    private final StatementExecuter executer;
    private final Printer printer;
    private final StatementParser statementParser;
    private final InputStream inputStream;

    public NonInteractiveShellRunner(FailBehavior failBehavior, StatementExecuter executer, Printer printer, StatementParser statementParser, InputStream inputStream) {
        this.failBehavior = failBehavior;
        this.executer = executer;
        this.printer = printer;
        this.statementParser = statementParser;
        this.inputStream = inputStream;
    }

    @Override
    public int runUntilEnd() {
        List<StatementParser.ParsedStatement> statements;
        try (InputStreamReader reader = new InputStreamReader(this.inputStream);){
            statements = this.statementParser.parse(reader).statements();
        }
        catch (Throwable e) {
            log.error(e);
            this.printer.printError(e);
            return 1;
        }
        int exitCode = 0;
        for (StatementParser.ParsedStatement statement : statements) {
            try {
                this.executer.execute(statement);
            }
            catch (ExitException e) {
                log.info("ExitException code=" + e.getCode() + ": " + e.getMessage());
                return e.getCode();
            }
            catch (Throwable e) {
                exitCode = 1;
                log.error(e);
                this.printer.printError(e);
                if (FailBehavior.FAIL_AT_END == this.failBehavior) continue;
                return exitCode;
            }
        }
        return exitCode;
    }

    @Override
    public Historian getHistorian() {
        return Historian.empty;
    }
}

