/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parameter;

import java.util.Map;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.parameter.ShellParameterService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ParameterService {
    public Map<String, Parameter> parameters();

    public Map<String, Object> parameterValues();

    public Parameter evaluate(RawParameter var1) throws CommandException;

    public void setParameter(Parameter var1);

    public RawParameter parse(String var1) throws ParameterParsingException;

    public static ParameterService create(TransactionHandler db) {
        return new ShellParameterService(db);
    }

    public static ParameterParser createParser() {
        return new ShellParameterService.ShellParameterParser();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ParameterParsingException
    extends Exception {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Parameter(String name, String expressionString, Object value) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record RawParameter(String name, String expression) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ParameterEvaluator {
        public Parameter evaluate(RawParameter var1) throws CommandException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ParameterParser {
        public RawParameter parse(String var1) throws ParameterParsingException;
    }
}

