/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Params
implements Command {
    private static final Pattern backtickPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*");
    private final Printer printer;
    private final ParameterService parameters;

    public Params(Printer printer, ParameterService parameters) {
        this.printer = printer;
        this.parameters = parameters;
    }

    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0, 1);
        if (args.size() == 0) {
            this.listAllParams();
        }
        if (args.size() == 1) {
            String trim = args.get(0).trim();
            Matcher matcher = backtickPattern.matcher(trim);
            if (trim.startsWith("`") && matcher.matches()) {
                this.listParam(trim);
            } else {
                String[] slittedArgs = trim.split("\\s+");
                if (slittedArgs.length > 0) {
                    this.listParam(slittedArgs[0]);
                } else {
                    this.listAllParams();
                }
            }
        }
    }

    private void listParam(String name) throws CommandException {
        String parameterName = CypherVariablesFormatter.unescapedCypherVariable(name);
        if (!this.parameters.parameters().containsKey(parameterName)) {
            throw new CommandException("Unknown parameter: " + name);
        }
        this.listParam(name.length(), name, this.parameters.parameters().get(parameterName).expressionString());
    }

    private void listParam(int leftColWidth, String key, Object value) {
        this.printer.printOut(String.format(":param %-" + leftColWidth + "s => %s", key, value));
    }

    private void listAllParams() {
        List<String> keys = this.parameters.parameters().keySet().stream().sorted().collect(Collectors.toList());
        int leftColWidth = keys.stream().map(s -> CypherVariablesFormatter.escape(s).length()).reduce(0, Math::max);
        keys.forEach(key -> this.listParam(leftColWidth, CypherVariablesFormatter.escape(key), this.parameters.parameters().get(key).expressionString()));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "Print a table of all currently set query parameters or the value for the given parameter";
            String description = "Print all query parameter values";
            return new Command.Metadata(":params", description, "[parameter]", help, List.of("parameters"));
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Params(args.printer(), args.parameters());
        }
    }
}

