/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.impl.action.StoreConstArgumentAction;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.impl.choice.CollectionArgumentChoice;
import net.sourceforge.argparse4j.impl.type.BooleanArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.neo4j.shell.Environment;
import org.neo4j.shell.cli.AddParamArgumentAction;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.cli.OnceArgumentAction;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CliArgHelper {
    private static final Logger log = Logger.create();
    public static final String USERNAME_ENV_VAR = "NEO4J_USERNAME";
    public static final String PASSWORD_ENV_VAR = "NEO4J_PASSWORD";
    public static final String DATABASE_ENV_VAR = "NEO4J_DATABASE";
    public static final String ADDRESS_ENV_VAR = "NEO4J_ADDRESS";
    public static final String URI_ENV_VAR = "NEO4J_URI";
    private static final String DEFAULT_ADDRESS = String.format("%s://%s:%d", "neo4j", "localhost", 7687);
    private final Environment environment;

    public CliArgHelper(Environment environment) {
        this.environment = environment;
    }

    public CliArgs parse(String ... args) {
        try {
            return this.parseAndThrow(args);
        }
        catch (ArgumentParserException e) {
            e.getParser().handleError(e);
            return null;
        }
    }

    private static void preValidateArguments(ArgumentParser parser, String ... args) throws ArgumentParserException {
        if (Arrays.asList(args).contains("-file")) {
            throw new ArgumentParserException("Unrecognized argument '-file', did you mean --file?", parser);
        }
    }

    public CliArgs parseAndThrow(String ... args) throws ArgumentParserException {
        CliArgs cliArgs = new CliArgs();
        ArgumentParser parser = CliArgHelper.setupParser();
        CliArgHelper.preValidateArguments(parser, args);
        Namespace ns = parser.parseArgs(args);
        return this.getCliArgs(cliArgs, parser, ns);
    }

    private Optional<String> addressFromEnvironment() {
        Optional<String> address = Optional.ofNullable(this.environment.getVariable(ADDRESS_ENV_VAR));
        Optional<String> uri = Optional.ofNullable(this.environment.getVariable(URI_ENV_VAR));
        if (address.isPresent() && uri.isPresent()) {
            throw new IllegalArgumentException("Specify one or none of environment variables NEO4J_ADDRESS and NEO4J_URI");
        }
        return address.or(() -> uri);
    }

    private CliArgs getCliArgs(CliArgs cliArgs, ArgumentParser parser, Namespace ns) throws ArgumentParserException {
        String address = Optional.ofNullable(ns.getString("address")).or(this::addressFromEnvironment).orElse(DEFAULT_ADDRESS);
        URI uri = CliArgHelper.parseURI(parser, address);
        cliArgs.setUri(uri);
        CliArgHelper.parseUserInfo(uri, cliArgs);
        Optional.ofNullable(ns.getString("username")).or(() -> Optional.ofNullable(this.environment.getVariable(USERNAME_ENV_VAR))).ifPresent(user -> cliArgs.setUsername((String)user, cliArgs.getUsername()));
        Optional.ofNullable(ns.getString("password")).or(() -> Optional.ofNullable(this.environment.getVariable(PASSWORD_ENV_VAR))).ifPresent(pass -> cliArgs.setPassword((String)pass, cliArgs.getPassword()));
        String impersonatedUser = ns.getString("impersonate");
        if (impersonatedUser != null) {
            cliArgs.setImpersonatedUser(impersonatedUser);
        }
        cliArgs.setEncryption(Encryption.parse((String)ns.get("encryption")));
        String database = Optional.ofNullable(ns.getString("database")).or(() -> Optional.ofNullable(this.environment.getVariable(DATABASE_ENV_VAR))).orElse("");
        cliArgs.setDatabase(database);
        cliArgs.setInputFilename(ns.getString("file"));
        cliArgs.setCypher(ns.getString("cypher"));
        cliArgs.setFailBehavior((FailBehavior)((Object)ns.get("fail-behavior")));
        cliArgs.setFormat(Format.parse((String)ns.get("format")));
        cliArgs.setParameters(ns.getList("param"));
        cliArgs.setNonInteractive(ns.getBoolean("force-non-interactive"));
        cliArgs.setWrap(ns.getBoolean("wrap"));
        cliArgs.setNumSampleRows(ns.getInt("sample-rows"));
        cliArgs.setVersion(ns.getBoolean("version"));
        cliArgs.setDriverVersion(ns.getBoolean("driver-version"));
        cliArgs.setChangePassword(ns.getBoolean("change-password"));
        cliArgs.setLogHandler((Handler)ns.get("log-file"));
        return cliArgs;
    }

    private static void parseUserInfo(URI uri, CliArgs cliArgs) {
        String userInfo = uri.getUserInfo();
        String user = null;
        String password = null;
        if (userInfo != null) {
            String[] split = userInfo.split(":");
            if (split.length == 0) {
                user = userInfo;
            } else if (split.length == 2) {
                user = split[0];
                password = split[1];
            } else {
                throw new IllegalArgumentException("Cannot parse user and password from " + userInfo);
            }
        }
        cliArgs.setUsername(user, "");
        cliArgs.setPassword(password, "");
    }

    static URI parseURI(ArgumentParser parser, String address) throws ArgumentParserException {
        try {
            URI uri;
            if (!((String)address).contains("://")) {
                address = "neo4j://" + (String)address;
            }
            if ((uri = new URI((String)address)).getPort() == -1) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 7687, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            log.error(e);
            String message = "cypher-shell: error: Failed to parse address: '%s'\nAddress should be of the form: [scheme://][username:password@][host][:port]".formatted(address);
            throw new ArgumentParserException(message, (Throwable)e, parser);
        }
    }

    private static ArgumentParser setupParser() {
        ArgumentParser parser = ArgumentParsers.newFor((String)"cypher-shell").defaultFormatWidth(100).build().defaultHelp(true).description(String.format("A command line shell where you can execute Cypher against an instance of Neo4j. By default the shell is interactive but you can use it for scripting by passing cypher directly on the command line or by piping a file with cypher statements (requires Powershell on Windows).%n%nexample of piping a file:%n  cat some-cypher.txt | cypher-shell", new Object[0]));
        ArgumentGroup connGroup = parser.addArgumentGroup("connection arguments");
        connGroup.addArgument(new String[]{"-a", "--address", "--uri"}).action((ArgumentAction)new OnceArgumentAction()).help("address and port to connect to, defaults to " + DEFAULT_ADDRESS + ". Can also be specified using environment variable NEO4J_ADDRESS or NEO4J_URI");
        connGroup.addArgument(new String[]{"-u", "--username"}).help("username to connect as. Can also be specified using environment variable NEO4J_USERNAME");
        connGroup.addArgument(new String[]{"--impersonate"}).help("user to impersonate.");
        connGroup.addArgument(new String[]{"-p", "--password"}).help("password to connect with. Can also be specified using environment variable NEO4J_PASSWORD");
        connGroup.addArgument(new String[]{"--encryption"}).help("whether the connection to Neo4j should be encrypted. This must be consistent with Neo4j's configuration. If choosing '" + Encryption.DEFAULT.name().toLowerCase() + "' the encryption setting is deduced from the specified address. For example the 'neo4j+ssc' protocol would use encryption.").choices((ArgumentChoice)new CollectionArgumentChoice((Object[])new String[]{Encryption.TRUE.name().toLowerCase(), Encryption.FALSE.name().toLowerCase(), Encryption.DEFAULT.name().toLowerCase()})).setDefault((Object)Encryption.DEFAULT.name().toLowerCase());
        connGroup.addArgument(new String[]{"-d", "--database"}).help("database to connect to. Can also be specified using environment variable NEO4J_DATABASE");
        MutuallyExclusiveGroup failGroup = parser.addMutuallyExclusiveGroup();
        failGroup.addArgument(new String[]{"--fail-fast"}).help("exit and report failure on first error when reading from file (this is the default behavior)").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_FAST).action((ArgumentAction)new StoreConstArgumentAction());
        failGroup.addArgument(new String[]{"--fail-at-end"}).help("exit and report failures at end of input when reading from file").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_AT_END).action((ArgumentAction)new StoreConstArgumentAction());
        parser.setDefault("fail-behavior", (Object)FailBehavior.FAIL_FAST);
        parser.addArgument(new String[]{"--format"}).help("desired output format, verbose displays results in tabular format and prints statistics, plain displays data with minimal formatting").choices((ArgumentChoice)new CollectionArgumentChoice((Object[])new String[]{Format.AUTO.name().toLowerCase(), Format.VERBOSE.name().toLowerCase(), Format.PLAIN.name().toLowerCase()})).setDefault((Object)Format.AUTO.name().toLowerCase());
        parser.addArgument(new String[]{"-P", "--param"}).help("Add a parameter to this session. Example: `-P \"number => 3\"` or `-P \"country => 'Spain'\"`. This argument can be specified multiple times.").action((ArgumentAction)new AddParamArgumentAction(ParameterService.createParser())).setDefault(new ArrayList());
        parser.addArgument(new String[]{"--non-interactive"}).help("force non-interactive mode, only useful if auto-detection fails (like on Windows)").dest("force-non-interactive").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--sample-rows"}).help("number of rows sampled to compute table widths (only for format=VERBOSE)").type((ArgumentType)new PositiveIntegerType()).dest("sample-rows").setDefault((Object)1000);
        parser.addArgument(new String[]{"--wrap"}).help("wrap table column values if column is too narrow (only for format=VERBOSE)").type((ArgumentType)new BooleanArgumentType()).setDefault((Object)true);
        parser.addArgument(new String[]{"-v", "--version"}).help("print version of cypher-shell and exit").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--driver-version"}).help("print version of the Neo4j Driver used and exit").dest("driver-version").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"cypher"}).nargs("?").help("an optional string of cypher to execute and then exit");
        parser.addArgument(new String[]{"-f", "--file"}).help("Pass a file with cypher statements to be executed. After the statements have been executed cypher-shell will be shutdown");
        parser.addArgument(new String[]{"--change-password"}).action((ArgumentAction)Arguments.storeTrue()).dest("change-password").help("change neo4j user password and exit");
        parser.addArgument(new String[]{"--log"}).nargs("?").type((ArgumentType)new LogHandlerType()).dest("log-file").help("enable logging to the specified file, or standard error if the file is omitted").setDefault((Object)null).setConst((Object)new ConsoleHandler());
        return parser;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PositiveIntegerType
    implements ArgumentType<Integer> {
        private PositiveIntegerType() {
        }

        public Integer convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
            try {
                int result = Integer.parseInt(value);
                if (result < 1) {
                    throw new NumberFormatException(value);
                }
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentParserException("Invalid value: " + value, parser);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class LogHandlerType
    implements ArgumentType<Handler> {
        private static final int MAX_BYTES = 100000000;
        private static final int LOG_FILE_COUNT = 1;

        private LogHandlerType() {
        }

        public Handler convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
            try {
                return new FileHandler(value, 100000000, 1, false);
            }
            catch (IOException e) {
                throw new ArgumentParserException("Failed to open log file: " + e.getMessage(), parser);
            }
        }
    }
}

