/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.neo4j.shell.terminal.SimplePrompt;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class StreamPrompt
implements SimplePrompt {
    private final InputStream in;
    private final PrintWriter out;

    StreamPrompt(InputStream in, PrintWriter out) {
        this.in = in;
        this.out = out;
    }

    protected abstract void disableEcho() throws IOException;

    protected abstract void restoreTerminal() throws IOException;

    protected abstract Charset charset();

    @Override
    public String readLine(String prompt) throws IOException {
        this.out.print(prompt);
        this.out.flush();
        return this.doReadLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readPassword(String prompt) throws IOException {
        this.out.print(prompt);
        this.out.flush();
        try {
            this.disableEcho();
            String read = this.doReadLine();
            if (read != null) {
                this.out.println();
                this.out.flush();
            }
            String string = read;
            return string;
        }
        finally {
            this.restoreTerminal();
        }
    }

    protected void onRead(int read) {
    }

    protected String doReadLine() throws IOException {
        int read;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((read = this.in.read()) != -1 && read != 10 && read != 13) {
            bytes.write(read);
            this.onRead(read);
        }
        this.onRead(read);
        return read == -1 ? null : bytes.toString(this.charset());
    }
}

