/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Expander;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Terminal;
import org.neo4j.shell.Historian;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.exception.UserInterruptException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.terminal.CypherJlineParser;
import org.neo4j.shell.terminal.CypherShellTerminal;

public class JlineTerminal
implements CypherShellTerminal {
    static final String NO_CONTINUATION_PROMPT_PATTERN = "  ";
    private final LineReader jLineReader;
    private final Logger logger;
    private final CypherShellTerminal.Reader reader;
    private final CypherShellTerminal.Writer writer;
    private final boolean isInteractive;

    public JlineTerminal(LineReader jLineReader, boolean isInteractive, Logger logger) {
        assert (jLineReader.getParser() instanceof CypherJlineParser);
        this.jLineReader = jLineReader;
        this.logger = logger;
        this.isInteractive = isInteractive;
        this.reader = new JLineReader();
        this.writer = new JLineWriter();
    }

    private CypherJlineParser getParser() {
        return (CypherJlineParser)this.jLineReader.getParser();
    }

    @Override
    public CypherShellTerminal.Reader read() {
        return this.reader;
    }

    @Override
    public CypherShellTerminal.Writer write() {
        return this.writer;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public Historian getHistory() {
        return new JlineHistorian();
    }

    @Override
    public void setHistoryFile(File file) {
        if (!file.equals(this.jLineReader.getVariable("history-file"))) {
            this.jLineReader.setVariable("history-file", (Object)file);
            this.loadHistory();
            Runtime.getRuntime().addShutdownHook(new Thread(this::flushHistory));
        }
    }

    @Override
    public void bindUserInterruptHandler(CypherShellTerminal.UserInterruptHandler handler) {
        this.jLineReader.getTerminal().handle(Terminal.Signal.INT, signal -> handler.handleUserInterrupt());
    }

    private void flushHistory() {
        try {
            this.getHistory().flushHistory();
        }
        catch (IOException e) {
            this.logger.printError("Failed to save history: " + e.getMessage());
        }
    }

    private void loadHistory() {
        try {
            this.jLineReader.getHistory().load();
        }
        catch (IOException e) {
            this.logger.printError("Failed to load history: " + e.getMessage());
        }
    }

    public static class EmptyExpander
    implements Expander {
        public String expandHistory(History history, String line) {
            return line;
        }

        public String expandVar(String word) {
            return word;
        }
    }

    private class JLineWriter
    implements CypherShellTerminal.Writer {
        private JLineWriter() {
        }

        @Override
        public void println(String line) {
            JlineTerminal.this.jLineReader.printAbove(line + System.lineSeparator());
        }
    }

    private class JLineReader
    implements CypherShellTerminal.Reader {
        private JLineReader() {
        }

        private String readLine(String prompt, Character mask) throws NoMoreInputException, UserInterruptException {
            try {
                return JlineTerminal.this.jLineReader.readLine(prompt, mask);
            }
            catch (EndOfFileException e) {
                throw new NoMoreInputException();
            }
            catch (org.jline.reader.UserInterruptException e) {
                throw new UserInterruptException(e.getPartialLine());
            }
        }

        @Override
        public CypherShellTerminal.ParsedStatement readStatement(AnsiFormattedText prompt) throws NoMoreInputException, UserInterruptException {
            JlineTerminal.this.getParser().setEnableStatementParsing(true);
            JlineTerminal.this.jLineReader.setVariable("secondary-prompt-pattern", (Object)this.continuationPromptPattern(prompt));
            String line = this.readLine(prompt.renderedString(), null);
            ParsedLine parsed = JlineTerminal.this.jLineReader.getParsedLine();
            if (!(parsed instanceof CypherShellTerminal.ParsedStatement)) {
                throw new IllegalStateException("Unexpected type of parsed line " + parsed.getClass().getSimpleName());
            }
            CypherShellTerminal.ParsedStatement parsedStatement = (CypherShellTerminal.ParsedStatement)parsed;
            if (!parsedStatement.unparsed().equals(line)) {
                throw new IllegalStateException("Parsed and unparsed lines do not match: " + line + " does not equal " + parsedStatement.unparsed());
            }
            return parsedStatement;
        }

        private String continuationPromptPattern(AnsiFormattedText prompt) {
            if (prompt.textLength() > 50) {
                return JlineTerminal.NO_CONTINUATION_PROMPT_PATTERN;
            }
            return " ".repeat(prompt.textLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String simplePrompt(String prompt, Character mask) throws NoMoreInputException, UserInterruptException {
            try {
                JlineTerminal.this.jLineReader.getVariables().put("disable-history", Boolean.TRUE);
                JlineTerminal.this.getParser().setEnableStatementParsing(false);
                String string = this.readLine(prompt, mask);
                return string;
            }
            finally {
                JlineTerminal.this.jLineReader.getVariables().remove("disable-history");
                JlineTerminal.this.getParser().setEnableStatementParsing(true);
            }
        }
    }

    private class JlineHistorian
    implements Historian {
        private JlineHistorian() {
        }

        @Override
        public List<String> getHistory() {
            JlineTerminal.this.loadHistory();
            return StreamSupport.stream(JlineTerminal.this.jLineReader.getHistory().spliterator(), false).map(History.Entry::line).collect(Collectors.toList());
        }

        @Override
        public void flushHistory() throws IOException {
            JlineTerminal.this.jLineReader.getHistory().save();
        }

        @Override
        public void clear() throws IOException {
            JlineTerminal.this.jLineReader.getHistory().purge();
        }
    }
}

