/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.neo4j.shell.Historian;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;

public class History
implements Command {
    private static final String COMMAND_NAME = ":history";
    private final Logger logger;
    private final Historian historian;
    private final List<String> aliases = Collections.emptyList();

    public History(Logger logger, Historian historian) {
        this.logger = logger;
        this.historian = historian;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDescription() {
        return "Print a list of the last commands executed";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getHelp() {
        return "':history' prints a list of the last statements executed\n':history clear' removes all entries from the history";
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(String argString) throws ExitException, CommandException {
        String[] args = CommandHelper.simpleArgParse(argString, 0, 1, COMMAND_NAME, this.getUsage());
        if (args.length == 1) {
            if (!"clear".equals(args[0])) throw new CommandException("Unrecognised argument " + args[0]);
            this.clearHistory();
            return;
        } else {
            int lineCount = 16;
            this.logger.printOut(History.printHistory(this.historian.getHistory(), lineCount));
        }
    }

    private static String printHistory(List<String> history, int lineCount) {
        int colWidth = Integer.toString(history.size()).length();
        String firstLineFormat = " %-" + colWidth + "d  %s%n";
        String continuationLineFormat = " %-" + colWidth + "s  %s%n";
        StringBuilder builder = new StringBuilder();
        for (int i = Math.max(0, history.size() - lineCount); i < history.size(); ++i) {
            String statement = history.get(i);
            String[] lines = statement.split("\\r?\\n");
            builder.append(String.format(firstLineFormat, i + 1, lines[0]));
            for (int l = 1; l < lines.length; ++l) {
                builder.append(String.format(continuationLineFormat, " ", lines[l]));
            }
        }
        return builder.toString();
    }

    private void clearHistory() throws CommandException {
        try {
            this.logger.printIfVerbose("Removing history...");
            this.historian.clear();
        }
        catch (IOException e) {
            throw new CommandException("Failed to clear history: " + e.getMessage());
        }
    }
}

