/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parameter;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.neo4j.shell.QueryRunner;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.parameter.ShellParameterService;

public interface ParameterService {
    public Map<String, Parameter> parameters();

    public Map<String, Object> parameterValues();

    public Parameter evaluate(RawParameter var1) throws CommandException;

    public void setParameter(Parameter var1);

    public RawParameter parse(String var1) throws ParameterParsingException;

    public static ParameterService create(QueryRunner db) {
        return new ShellParameterService(db);
    }

    public static ParameterParser createParser() {
        return new ShellParameterService.ShellParameterParser();
    }

    public static class ParameterParsingException
    extends Exception {
    }

    public static class Parameter {
        public final String name;
        public final String expressionString;
        public final Object value;

        public Parameter(String name, String expressionString, Object value) {
            this.name = name;
            this.expressionString = expressionString;
            this.value = value;
        }

        public String toString() {
            return new StringJoiner(", ", Parameter.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("expressionString='" + this.expressionString + "'").add("value=" + String.valueOf(this.value)).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.name.equals(parameter.name) && this.expressionString.equals(parameter.expressionString) && this.value.equals(parameter.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.expressionString, this.value);
        }
    }

    public static class RawParameter {
        public final String name;
        public final String expression;

        public RawParameter(String name, String expression) {
            this.name = name;
            this.expression = expression;
        }

        public String toString() {
            return "RawParameter{name='" + this.name + "', expression='" + this.expression + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawParameter that = (RawParameter)o;
            return this.name.equals(that.name) && this.expression.equals(that.expression);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.expression);
        }
    }

    public static interface ParameterEvaluator {
        public Parameter evaluate(RawParameter var1) throws CommandException;
    }

    public static interface ParameterParser {
        public RawParameter parse(String var1) throws ParameterParsingException;
    }
}

