/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Closeable;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.build.Build;
import org.neo4j.shell.cli.CliArgHelper;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ThrowingAction;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.AnsiLogger;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.prettyprint.PrettyPrinter;
import org.neo4j.shell.state.BoltStateHandler;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.CypherShellTerminalBuilder;
import org.neo4j.shell.terminal.SimplePrompt;
import org.neo4j.shell.util.Versions;
import org.neo4j.util.VisibleForTesting;

public class Main
implements Closeable {
    public static final int EXIT_FAILURE = 1;
    public static final int EXIT_SUCCESS = 0;
    static final String NEO_CLIENT_ERROR_SECURITY_UNAUTHORIZED = "Neo.ClientError.Security.Unauthorized";
    private final CliArgs args;
    private final Logger logger;
    private final CypherShell shell;
    private final boolean isOutputInteractive;
    private final ShellRunner.Factory runnerFactory;
    private final CypherShellTerminal terminal;
    private final ParameterService parameters;

    public Main(CliArgs args) {
        boolean isInteractive = !args.getNonInteractive() && ShellRunner.isInputInteractive();
        this.logger = new AnsiLogger(args.getDebugMode(), Format.VERBOSE, System.out, System.err);
        this.terminal = CypherShellTerminalBuilder.terminalBuilder().interactive(isInteractive).logger(this.logger).build();
        this.args = args;
        PrettyPrinter prettyPrinter = new PrettyPrinter(new PrettyConfig(args));
        BoltStateHandler boltStateHandler = new BoltStateHandler(ShellRunner.shouldBeInteractive(args, this.terminal.isInteractive()));
        this.parameters = ParameterService.create(boltStateHandler);
        this.shell = new CypherShell(this.logger, boltStateHandler, prettyPrinter, this.parameters);
        this.isOutputInteractive = !args.getNonInteractive() && ShellRunner.isOutputInteractive();
        this.runnerFactory = new ShellRunner.Factory();
    }

    @VisibleForTesting
    public Main(CliArgs args, PrintStream out, PrintStream err, boolean outputInteractive, CypherShellTerminal terminal) {
        this.terminal = terminal;
        this.args = args;
        this.logger = new AnsiLogger(args.getDebugMode(), Format.VERBOSE, out, err);
        BoltStateHandler boltStateHandler = new BoltStateHandler(ShellRunner.shouldBeInteractive(args, terminal.isInteractive()));
        this.parameters = ParameterService.create(boltStateHandler);
        this.shell = new CypherShell(this.logger, boltStateHandler, new PrettyPrinter(new PrettyConfig(args)), this.parameters);
        this.isOutputInteractive = outputInteractive;
        this.runnerFactory = new ShellRunner.Factory();
    }

    @VisibleForTesting
    public Main(CliArgs args, AnsiLogger logger, CypherShell shell, ParameterService parameters, boolean outputInteractive, ShellRunner.Factory runnerFactory, CypherShellTerminal terminal) {
        this.terminal = terminal;
        this.args = args;
        this.logger = logger;
        this.shell = shell;
        this.isOutputInteractive = outputInteractive;
        this.runnerFactory = runnerFactory;
        this.parameters = parameters;
    }

    public static void main(String[] args) {
        int exitCode;
        CliArgs cliArgs = CliArgHelper.parse(args);
        if (cliArgs == null) {
            System.exit(1);
        }
        Main.setupLogging();
        try (Main main = new Main(cliArgs);){
            exitCode = main.startShell();
        }
        System.exit(exitCode);
    }

    public int startShell() {
        if (this.args.getVersion()) {
            this.terminal.write().println("Cypher-Shell " + Build.version());
            return 0;
        }
        if (this.args.getDriverVersion()) {
            this.terminal.write().println("Neo4j Driver " + Build.driverVersion());
            return 0;
        }
        if (this.args.getChangePassword()) {
            return this.runSetNewPassword();
        }
        return this.runShell();
    }

    private int runSetNewPassword() {
        try {
            this.promptAndChangePassword(this.args.connectionConfig(), null);
        }
        catch (Exception e) {
            this.logger.printError("Failed to change password: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int runShell() {
        ConnectionConfig connectionConfig = this.args.connectionConfig();
        try {
            if (this.args.getCypher().isPresent()) {
                this.connectMaybeInteractively(connectionConfig, () -> this.shell.execute(this.args.getCypher().get()));
                return 0;
            }
            ConnectionConfig newConnectionConfig = this.connectMaybeInteractively(connectionConfig, null);
            if (!newConnectionConfig.driverUrl().equals(connectionConfig.driverUrl())) {
                String fallbackWarning = "Failed to connect to " + connectionConfig.driverUrl() + ", fallback to " + newConnectionConfig.driverUrl();
                this.logger.printIfVerbose(AnsiFormattedText.s().colorOrange().append(fallbackWarning).formattedString());
            }
            ShellRunner shellRunner = this.runnerFactory.create(this.args, this.shell, this.logger, newConnectionConfig, this.terminal);
            CommandHelper commandHelper = new CommandHelper(this.logger, shellRunner.getHistorian(), this.shell, newConnectionConfig, this.terminal);
            this.shell.setCommandHelper(commandHelper);
            return shellRunner.runUntilEnd();
        }
        catch (Throwable e) {
            this.logger.printError(e);
            return 1;
        }
    }

    private ConnectionConfig connectMaybeInteractively(ConnectionConfig connectionConfig, ThrowingAction<CommandException> command) throws Exception {
        boolean didPrompt = false;
        if (this.terminal.isInteractive() && !connectionConfig.username().isEmpty() && connectionConfig.password().isEmpty()) {
            this.promptForUsernameAndPassword(connectionConfig);
            didPrompt = true;
        }
        while (true) {
            try {
                ConnectionConfig newConf = this.shell.connect(connectionConfig, command);
                this.setArgumentParameters();
                return newConf;
            }
            catch (AuthenticationException e) {
                if (didPrompt || !this.terminal.isInteractive() || !connectionConfig.username().isEmpty() && !connectionConfig.password().isEmpty()) {
                    throw e;
                }
                this.promptForUsernameAndPassword(connectionConfig);
                didPrompt = true;
                continue;
            }
            catch (Neo4jException e) {
                if (this.terminal.isInteractive() && Versions.isPasswordChangeRequiredException(e)) {
                    this.promptAndChangePassword(connectionConfig, "Password change required");
                    didPrompt = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void promptForUsernameAndPassword(ConnectionConfig connectionConfig) throws Exception {
        if (connectionConfig.username().isEmpty()) {
            String username = this.isOutputInteractive ? this.promptForNonEmptyText("username", false) : this.promptForText("username", false);
            connectionConfig.setUsername(username);
        }
        if (connectionConfig.password().isEmpty()) {
            connectionConfig.setPassword(this.promptForText("password", true));
        }
    }

    private ConnectionConfig promptAndChangePassword(ConnectionConfig connectionConfig, String message) throws Exception {
        if (message != null) {
            this.terminal.write().println(message);
        }
        if (connectionConfig.username().isEmpty()) {
            String username = this.isOutputInteractive ? this.promptForNonEmptyText("username", false) : this.promptForText("username", false);
            connectionConfig.setUsername(username);
        }
        if (connectionConfig.password().isEmpty()) {
            connectionConfig.setPassword(this.promptForText("password", true));
        }
        String newPassword = this.isOutputInteractive ? this.promptForNonEmptyText("new password", true) : this.promptForText("new password", true);
        String reenteredNewPassword = this.promptForText("confirm password", true);
        if (!reenteredNewPassword.equals(newPassword)) {
            throw new CommandException("Passwords are not matching.");
        }
        this.shell.changePassword(connectionConfig, newPassword);
        connectionConfig.setPassword(newPassword);
        return connectionConfig;
    }

    @VisibleForTesting
    protected CypherShell getCypherShell() {
        return this.shell;
    }

    private String promptForNonEmptyText(String prompt, boolean maskInput) throws Exception {
        String text = this.promptForText(prompt, maskInput);
        while (text.isEmpty()) {
            text = this.promptForText(String.format("%s cannot be empty%n%n%s", prompt, prompt), maskInput);
        }
        return text;
    }

    private String promptForText(String prompt, boolean maskInput) throws CommandException {
        String read;
        try (SimplePrompt simplePrompt = this.terminal.simplePrompt();){
            String promptWithColon = prompt + ": ";
            read = maskInput ? simplePrompt.readPassword(promptWithColon) : simplePrompt.readLine(promptWithColon);
        }
        catch (Exception e) {
            throw new CommandException("No text could be read, exiting...");
        }
        if (read == null) {
            throw new CommandException("No text could be read, exiting...");
        }
        return read;
    }

    private static void setupLogging() {
        try {
            LogManager.getLogManager().getLogger("").setLevel(Level.OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.shell.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setArgumentParameters() throws CommandException {
        for (ParameterService.RawParameter parameter : this.args.getParameters()) {
            this.parameters.setParameter(this.parameters.evaluate(parameter));
        }
    }
}

