/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.parameter.ParameterService;

public class Param
implements Command {
    private static final String COMMAND_NAME = ":param";
    private final ParameterService parameters;

    public Param(ParameterService parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDescription() {
        return "Set the value of a query parameter";
    }

    @Override
    public String getUsage() {
        return "name => <Cypher Expression>";
    }

    @Override
    public String getHelp() {
        return "Set the specified query parameter to the value given";
    }

    @Override
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public void execute(String args) throws ExitException, CommandException {
        try {
            ParameterService.RawParameter parsed = this.parameters.parse(args);
            this.parameters.setParameter(this.parameters.evaluate(parsed));
        }
        catch (ParameterService.ParameterParsingException e) {
            throw new CommandException(AnsiFormattedText.from("Incorrect usage.\nusage: ").bold(this.getName()).append(" ").append(this.getUsage()));
        }
    }
}

