/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Connector;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.UserMessagesHandler;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.exception.UserInterruptException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.util.VisibleForTesting;

public class InteractiveShellRunner
implements ShellRunner,
CypherShellTerminal.UserInterruptHandler {
    static final String INTERRUPT_SIGNAL = "INT";
    static final String UNRESOLVED_DEFAULT_DB_PROPMPT_TEXT = "<default_database>";
    static final String DATABASE_UNAVAILABLE_ERROR_PROMPT_TEXT = "[UNAVAILABLE]";
    private static final String FRESH_PROMPT = "> ";
    private static final String TRANSACTION_PROMPT = "# ";
    private static final String USERNAME_DB_DELIMITER = "@";
    private final AtomicBoolean currentlyExecuting;
    private final Logger logger;
    private final CypherShellTerminal terminal;
    private final TransactionHandler txHandler;
    private final DatabaseManager databaseManager;
    private final StatementExecuter executer;
    private final UserMessagesHandler userMessagesHandler;
    private final ConnectionConfig connectionConfig;
    private final Connector connector;

    public InteractiveShellRunner(StatementExecuter executer, TransactionHandler txHandler, DatabaseManager databaseManager, Connector connector, Logger logger, CypherShellTerminal terminal, UserMessagesHandler userMessagesHandler, ConnectionConfig connectionConfig, File historyFile) {
        this.userMessagesHandler = userMessagesHandler;
        this.currentlyExecuting = new AtomicBoolean(false);
        this.executer = executer;
        this.txHandler = txHandler;
        this.databaseManager = databaseManager;
        this.connector = connector;
        this.logger = logger;
        this.terminal = terminal;
        this.connectionConfig = connectionConfig;
        this.setupHistory(historyFile);
        terminal.bindUserInterruptHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runUntilEnd() {
        int exitCode = 0;
        boolean running = true;
        this.logger.printIfVerbose(this.userMessagesHandler.getWelcomeMessage());
        while (running) {
            try {
                for (String statement : this.readUntilStatement()) {
                    this.currentlyExecuting.set(true);
                    this.executer.execute(statement);
                    this.currentlyExecuting.set(false);
                }
            }
            catch (ExitException e) {
                exitCode = e.getCode();
                running = false;
            }
            catch (NoMoreInputException e) {
                running = false;
            }
            catch (Throwable e) {
                this.logger.printError(e);
            }
            finally {
                this.currentlyExecuting.set(false);
            }
        }
        this.logger.printIfVerbose(UserMessagesHandler.getExitMessage());
        this.flushHistory();
        return exitCode;
    }

    @Override
    public Historian getHistorian() {
        return this.terminal.getHistory();
    }

    @VisibleForTesting
    protected List<String> readUntilStatement() throws NoMoreInputException {
        while (true) {
            try {
                return this.terminal.read().readStatement(this.updateAndGetPrompt()).parsed();
            }
            catch (UserInterruptException e) {
                this.handleUserInterrupt();
                continue;
            }
            break;
        }
    }

    private AnsiFormattedText updateAndGetPrompt() {
        String databaseName = this.databaseManager.getActualDatabaseAsReportedByServer();
        if (databaseName == null || "".equals(databaseName)) {
            String dbNameSetByUser = this.databaseManager.getActiveDatabaseAsSetByUser();
            databaseName = "".equals(dbNameSetByUser) ? UNRESOLVED_DEFAULT_DB_PROPMPT_TEXT : dbNameSetByUser;
        }
        String errorSuffix = InteractiveShellRunner.getErrorPrompt(this.executer.lastNeo4jErrorCode());
        int promptIndent = this.connectionConfig.username().length() + USERNAME_DB_DELIMITER.length() + databaseName.length() + errorSuffix.length() + FRESH_PROMPT.length();
        AnsiFormattedText prePrompt = this.getPrePrompt(databaseName);
        if (!errorSuffix.isEmpty()) {
            prePrompt.colorRed().append(errorSuffix).colorDefault();
        }
        if (promptIndent <= 50) {
            return prePrompt.append(this.txHandler.isTransactionOpen() ? TRANSACTION_PROMPT : FRESH_PROMPT);
        }
        return prePrompt.appendNewLine().append(this.txHandler.isTransactionOpen() ? TRANSACTION_PROMPT : FRESH_PROMPT);
    }

    private AnsiFormattedText getPrePrompt(String databaseName) {
        AnsiFormattedText prePrompt = AnsiFormattedText.s().bold();
        if (this.connector.isConnected()) {
            prePrompt.append(this.connectionConfig.username()).append(USERNAME_DB_DELIMITER).append(databaseName);
        } else {
            prePrompt.append("Disconnected");
        }
        return prePrompt;
    }

    private static String getErrorPrompt(String errorCode) {
        String errorPromptSuffix = "Neo.TransientError.General.DatabaseUnavailable".equals(errorCode) ? DATABASE_UNAVAILABLE_ERROR_PROMPT_TEXT : "";
        return errorPromptSuffix;
    }

    private void setupHistory(File historyFile) {
        File dir = historyFile.getParentFile();
        if (!dir.isDirectory() && !dir.mkdir()) {
            this.logger.printError("Could not load history file. Falling back to session-based history.\n");
        } else {
            this.terminal.setHistoryFile(historyFile);
        }
    }

    private void flushHistory() {
        try {
            this.getHistorian().flushHistory();
        }
        catch (IOException e) {
            this.logger.printError("Failed to save history: " + e.getMessage());
        }
    }

    @Override
    public void handleUserInterrupt() {
        if (this.currentlyExecuting.get()) {
            this.logger.printError("Stopping query...");
            this.executer.reset();
        } else {
            this.logger.printError(AnsiFormattedText.s().colorRed().append("Interrupted (Note that Cypher queries must end with a ").bold("semicolon").append(". Type ").bold(":exit").append(" to exit the shell.)").formattedString());
        }
    }
}

