/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.Evaluator;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.literal.interpreter.LiteralInterpreter;
import org.neo4j.cypher.internal.parser.javacc.CharStream;
import org.neo4j.cypher.internal.parser.javacc.Cypher;
import org.neo4j.cypher.internal.parser.javacc.CypherCharStream;
import org.neo4j.cypher.internal.parser.javacc.ParseException;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.exception.ParameterException;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;
import org.neo4j.shell.state.ParamValue;

public class ShellParameterMap
implements ParameterMap {
    private final Map<String, ParamValue> queryParams = new HashMap<String, ParamValue>();
    private LiteralInterpreter interpreter = new LiteralInterpreter();
    private ExpressionEvaluator evaluator = Evaluator.expressionEvaluator();

    @Override
    public Object setParameter(String name, String valueString) throws ParameterException {
        String parameterName = CypherVariablesFormatter.unescapedCypherVariable(name);
        try {
            Object value = new Cypher((ASTFactory)this.interpreter, ParameterException.FACTORY, (CharStream)new CypherCharStream(valueString)).Expression();
            this.queryParams.put(parameterName, new ParamValue(valueString, value));
            return value;
        }
        catch (UnsupportedOperationException | ParseException e) {
            try {
                Object value = this.evaluator.evaluate(valueString, Object.class);
                this.queryParams.put(parameterName, new ParamValue(valueString, value));
                return value;
            }
            catch (EvaluationException e1) {
                throw new ParameterException(e1.getMessage());
            }
        }
    }

    @Override
    public Map<String, Object> allParameterValues() {
        return this.queryParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((ParamValue)value.getValue()).getValue()));
    }

    @Override
    public Map<String, ParamValue> getAllAsUserInput() {
        return this.queryParams;
    }
}

