/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;

public class Exit
implements Command {
    public static final String COMMAND_NAME = ":exit";
    private final Logger logger;

    public Exit(@Nonnull Logger logger) {
        this.logger = logger;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Exit the logger";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return AnsiFormattedText.from("Exit the logger. Corresponds to entering ").bold().append("CTRL-D").boldOff().append(".").formattedString();
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Arrays.asList(":quit");
    }

    @Override
    public void execute(@Nonnull String argString) throws ExitException, CommandException {
        CommandHelper.simpleArgParse(argString, 0, COMMAND_NAME, this.getUsage());
        throw new ExitException(0);
    }
}

