/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;

public class NonInteractiveShellRunner
implements ShellRunner {
    private final FailBehavior failBehavior;
    @Nonnull
    private final StatementExecuter executer;
    private final Logger logger;
    private final StatementParser statementParser;
    private final InputStream inputStream;

    public NonInteractiveShellRunner(@Nonnull FailBehavior failBehavior, @Nonnull StatementExecuter executer, @Nonnull Logger logger, @Nonnull StatementParser statementParser, @Nonnull InputStream inputStream) {
        this.failBehavior = failBehavior;
        this.executer = executer;
        this.logger = logger;
        this.statementParser = statementParser;
        this.inputStream = inputStream;
    }

    @Override
    public int runUntilEnd() {
        List<String> statements;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));){
            bufferedReader.lines().forEach(line -> this.statementParser.parseMoreText(line + "\n"));
            statements = this.statementParser.consumeStatements();
        }
        catch (Throwable e) {
            this.logger.printError(e);
            return 1;
        }
        int exitCode = 0;
        for (String statement : statements) {
            try {
                this.executer.execute(statement);
            }
            catch (ExitException e) {
                return e.getCode();
            }
            catch (Throwable e) {
                exitCode = 1;
                this.logger.printError(e);
                if (FailBehavior.FAIL_AT_END == this.failBehavior) continue;
                return exitCode;
            }
        }
        return exitCode;
    }

    @Override
    @Nonnull
    public Historian getHistorian() {
        return Historian.empty;
    }
}

