/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.driver.Record;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.shell.state.BoltResult;

public class ListBoltResult
implements BoltResult {
    private final List<String> keys;
    private final List<Record> records;
    private final ResultSummary summary;

    public ListBoltResult(@Nonnull List<Record> records, @Nonnull ResultSummary summary) {
        this(records, summary, records.isEmpty() ? Collections.emptyList() : records.get(0).keys());
    }

    public ListBoltResult(@Nonnull List<Record> records, @Nonnull ResultSummary summary, @Nonnull List<String> keys) {
        this.keys = keys;
        this.records = records;
        this.summary = summary;
    }

    @Override
    @Nonnull
    public List<String> getKeys() {
        return this.keys;
    }

    @Override
    @Nonnull
    public List<Record> getRecords() {
        return this.records;
    }

    @Override
    @Nonnull
    public Iterator<Record> iterate() {
        return this.records.iterator();
    }

    @Override
    @Nonnull
    public ResultSummary getSummary() {
        return this.summary;
    }
}

