/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import javax.annotation.Nonnull;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.util.Version;
import org.neo4j.shell.util.Versions;

public class UserMessagesHandler {
    private ConnectionConfig connectionConfig;
    private String serverVersion;

    public UserMessagesHandler(@Nonnull ConnectionConfig connectionConfig, @Nonnull String serverVersion) {
        this.connectionConfig = connectionConfig;
        this.serverVersion = serverVersion;
    }

    @Nonnull
    public String getWelcomeMessage() {
        Object neo4j = "Neo4j";
        if (!this.serverVersion.isEmpty()) {
            Version version = Versions.version(this.serverVersion);
            neo4j = (String)neo4j + " using Bolt protocol version " + version.major() + "." + version.minor();
        }
        AnsiFormattedText welcomeMessage = AnsiFormattedText.from("Connected to ").append((String)neo4j).append(" at ").bold().append(this.connectionConfig.driverUrl()).boldOff();
        if (!this.connectionConfig.username().isEmpty()) {
            welcomeMessage = welcomeMessage.append(" as user ").bold().append(this.connectionConfig.username()).boldOff();
        }
        return welcomeMessage.append(".\nType ").bold().append(":help").boldOff().append(" for a list of available commands or ").bold().append(":exit").boldOff().append(" to exit the shell.").append("\nNote that Cypher queries must end with a ").bold().append("semicolon.").boldOff().formattedString();
    }

    @Nonnull
    public String getExitMessage() {
        return AnsiFormattedText.s().append("\nBye!").formattedString();
    }
}

