/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.shell.Historian;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;

public class History
implements Command {
    private static final String COMMAND_NAME = ":history";
    private final Logger logger;
    private final Historian historian;
    private final List<String> aliases = Collections.emptyList();

    public History(@Nonnull Logger logger, @Nonnull Historian historian) {
        this.logger = logger;
        this.historian = historian;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Print a list of the last commands executed";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return "Print a list of the last commands executed.";
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public void execute(@Nonnull String argString) throws ExitException, CommandException {
        CommandHelper.simpleArgParse(argString, 0, COMMAND_NAME, this.getUsage());
        int lineCount = 16;
        this.logger.printOut(this.printHistory(this.historian.getHistory(), lineCount));
    }

    private String printHistory(@Nonnull List<String> history, int lineCount) {
        int colWidth = Integer.toString(history.size()).length();
        String fmt = " %-" + colWidth + "d  %s\n";
        Object result = "";
        int count = 0;
        for (int i = history.size() - 1; i >= 0 && count < lineCount; --i, ++count) {
            String line = history.get(i);
            result = String.format(fmt, i + 1, line) + (String)result;
        }
        return result;
    }
}

