/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreConstArgumentAction;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.impl.choice.CollectionArgumentChoice;
import net.sourceforge.argparse4j.impl.type.BooleanArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.cli.AddParamArgumentAction;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;

public class CliArgHelper {
    @Nullable
    public static CliArgs parse(String ... args) {
        Namespace ns;
        CliArgs cliArgs = new CliArgs();
        ArgumentParser parser = CliArgHelper.setupParser(cliArgs.getParameters());
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return null;
        }
        return CliArgHelper.getCliArgs(cliArgs, parser, ns);
    }

    public static CliArgs parseAndThrow(String ... args) throws ArgumentParserException {
        CliArgs cliArgs = new CliArgs();
        ArgumentParser parser = CliArgHelper.setupParser(cliArgs.getParameters());
        Namespace ns = parser.parseArgs(args);
        return CliArgHelper.getCliArgs(cliArgs, parser, ns);
    }

    private static CliArgs getCliArgs(CliArgs cliArgs, ArgumentParser parser, Namespace ns) {
        String pass;
        URI uri = CliArgHelper.parseURI(parser, ns.getString("address"));
        if (uri == null) {
            return null;
        }
        cliArgs.setScheme(uri.getScheme(), "bolt");
        cliArgs.setHost(uri.getHost(), "localhost");
        int port = uri.getPort();
        cliArgs.setPort(port == -1 ? 7687 : port);
        CliArgHelper.parseUserInfo(uri, cliArgs);
        String user = ns.getString("username");
        if (!user.isEmpty()) {
            cliArgs.setUsername(user, cliArgs.getUsername());
        }
        if (!(pass = ns.getString("password")).isEmpty()) {
            cliArgs.setPassword(pass, cliArgs.getPassword());
        }
        cliArgs.setEncryption(Encryption.parse((String)ns.get("encryption")));
        cliArgs.setDatabase(ns.getString("database"));
        cliArgs.setInputFilename(ns.getString("file"));
        cliArgs.setCypher(ns.getString("cypher"));
        cliArgs.setFailBehavior((FailBehavior)((Object)ns.get("fail-behavior")));
        cliArgs.setFormat(Format.parse((String)ns.get("format")));
        cliArgs.setDebugMode(ns.getBoolean("debug"));
        cliArgs.setNonInteractive(ns.getBoolean("force-non-interactive"));
        cliArgs.setWrap(ns.getBoolean("wrap"));
        cliArgs.setNumSampleRows(ns.getInt("sample-rows"));
        cliArgs.setVersion(ns.getBoolean("version"));
        cliArgs.setDriverVersion(ns.getBoolean("driver-version"));
        return cliArgs;
    }

    private static void parseUserInfo(URI uri, CliArgs cliArgs) {
        String userInfo = uri.getUserInfo();
        String user = null;
        String password = null;
        if (userInfo != null) {
            String[] split = userInfo.split(":");
            if (split.length == 0) {
                user = userInfo;
            } else if (split.length == 2) {
                user = split[0];
                password = split[1];
            } else {
                throw new IllegalArgumentException("Cannot parse user and password from " + userInfo);
            }
        }
        cliArgs.setUsername(user, "");
        cliArgs.setPassword(password, "");
    }

    @Nullable
    static URI parseURI(ArgumentParser parser, String address) {
        try {
            String[] schemeSplit = ((String)address).split("://");
            if (schemeSplit.length == 1) {
                address = "bolt://" + (String)address;
            }
            return new URI((String)address);
        }
        catch (URISyntaxException e) {
            PrintWriter printWriter = new PrintWriter(System.err);
            parser.printUsage(printWriter);
            printWriter.println("cypher-shell: error: Failed to parse address: '" + (String)address + "'");
            printWriter.println("\n  Address should be of the form: [scheme://][username:password@][host][:port]");
            printWriter.flush();
            return null;
        }
    }

    private static ArgumentParser setupParser(ParameterMap parameterMap) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"cypher-shell").defaultHelp(true).description(String.format("A command line shell where you can execute Cypher against an instance of Neo4j. By default the shell is interactive but you can use it for scripting by passing cypher directly on the command line or by piping a file with cypher statements (requires Powershell on Windows).%n%nexample of piping a file:%n  cat some-cypher.txt | cypher-shell", new Object[0]));
        ArgumentGroup connGroup = parser.addArgumentGroup("connection arguments");
        connGroup.addArgument(new String[]{"-a", "--address"}).help("address and port to connect to").setDefault((Object)"neo4j://localhost:7687");
        connGroup.addArgument(new String[]{"-u", "--username"}).setDefault((Object)"").help("username to connect as. Can also be specified using environment variable NEO4J_USERNAME");
        connGroup.addArgument(new String[]{"-p", "--password"}).setDefault((Object)"").help("password to connect with. Can also be specified using environment variable NEO4J_PASSWORD");
        connGroup.addArgument(new String[]{"--encryption"}).help("whether the connection to Neo4j should be encrypted. This must be consistent with Neo4j's configuration. If choosing '" + Encryption.DEFAULT.name().toLowerCase() + "' the encryption setting is deduced from the specified address. For example the 'neo4j+ssc' protocol would use encryption.").choices((ArgumentChoice)new CollectionArgumentChoice((Object[])new String[]{Encryption.TRUE.name().toLowerCase(), Encryption.FALSE.name().toLowerCase(), Encryption.DEFAULT.name().toLowerCase()})).setDefault((Object)Encryption.DEFAULT.name().toLowerCase());
        connGroup.addArgument(new String[]{"-d", "--database"}).help("database to connect to. Can also be specified using environment variable NEO4J_DATABASE").setDefault((Object)"");
        MutuallyExclusiveGroup failGroup = parser.addMutuallyExclusiveGroup();
        failGroup.addArgument(new String[]{"--fail-fast"}).help("exit and report failure on first error when reading from file (this is the default behavior)").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_FAST).action((ArgumentAction)new StoreConstArgumentAction());
        failGroup.addArgument(new String[]{"--fail-at-end"}).help("exit and report failures at end of input when reading from file").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_AT_END).action((ArgumentAction)new StoreConstArgumentAction());
        parser.setDefault("fail-behavior", (Object)FailBehavior.FAIL_FAST);
        parser.addArgument(new String[]{"--format"}).help("desired output format, verbose displays results in tabular format and prints statistics, plain displays data with minimal formatting").choices((ArgumentChoice)new CollectionArgumentChoice((Object[])new String[]{Format.AUTO.name().toLowerCase(), Format.VERBOSE.name().toLowerCase(), Format.PLAIN.name().toLowerCase()})).setDefault((Object)Format.AUTO.name().toLowerCase());
        parser.addArgument(new String[]{"-P", "--param"}).help("Add a parameter to this session. Example: `-P \"number => 3\"`. This argument can be specified multiple times.").action((ArgumentAction)new AddParamArgumentAction(parameterMap));
        parser.addArgument(new String[]{"--debug"}).help("print additional debug information").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--non-interactive"}).help("force non-interactive mode, only useful if auto-detection fails (like on Windows)").dest("force-non-interactive").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--sample-rows"}).help("number of rows sampled to compute table widths (only for format=VERBOSE)").type((ArgumentType)new PositiveIntegerType()).dest("sample-rows").setDefault((Object)1000);
        parser.addArgument(new String[]{"--wrap"}).help("wrap table column values if column is too narrow (only for format=VERBOSE)").type((ArgumentType)new BooleanArgumentType()).setDefault((Object)true);
        parser.addArgument(new String[]{"-v", "--version"}).help("print version of cypher-shell and exit").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--driver-version"}).help("print version of the Neo4j Driver used and exit").dest("driver-version").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"cypher"}).nargs("?").help("an optional string of cypher to execute and then exit");
        parser.addArgument(new String[]{"-f", "--file"}).help("Pass a file with cypher statements to be executed. After the statements have been executed cypher-shell will be shutdown");
        return parser;
    }

    private static class PositiveIntegerType
    implements ArgumentType<Integer> {
        private PositiveIntegerType() {
        }

        public Integer convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
            try {
                int result = Integer.parseInt(value);
                if (result < 1) {
                    throw new NumberFormatException(value);
                }
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentParserException("Invalid value: " + value, parser);
            }
        }
    }
}

