/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.AnsiFormattedText;

public class Param
implements Command {
    public static final String COMMAND_NAME = ":param";
    private static final Pattern backtickPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?):?\\s+(?<value>.+)$");
    private static final Pattern backtickLambdaPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*=>\\s*(?<value>.+)$");
    private static final Pattern argPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):?\\s+(?<value>.+)$");
    private static final Pattern lambdaPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*)\\s*=>\\s*(?<value>.+)$");
    private static final Pattern lambdaMapPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):\\s*=>\\s*(?<value>.+)$");
    private final ParameterMap parameterMap;

    public Param(@Nonnull ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Set the value of a query parameter";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "name => value";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return "Set the specified query parameter to the value given";
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public void execute(@Nonnull String argString) throws CommandException {
        Matcher lambdaMapMatcher = lambdaMapPattern.matcher(argString);
        if (lambdaMapMatcher.matches()) {
            throw new CommandException(AnsiFormattedText.from("Incorrect usage.\nusage: ").bold().append(COMMAND_NAME).boldOff().append(" ").append(this.getUsage()));
        }
        if (!this.assignIfValidParameter(argString)) {
            throw new CommandException(AnsiFormattedText.from("Incorrect number of arguments.\nusage: ").bold().append(COMMAND_NAME).boldOff().append(" ").append(this.getUsage()));
        }
    }

    private boolean assignIfValidParameter(@Nonnull String argString) throws CommandException {
        return this.setParameterIfItMatchesPattern(argString, lambdaPattern, this.assignIfValidParameter()) || this.setParameterIfItMatchesPattern(argString, argPattern, this.assignIfValidParameter()) || this.setParameterIfItMatchesPattern(argString, backtickLambdaPattern, this.backTickMatchPattern()) || this.setParameterIfItMatchesPattern(argString, backtickPattern, this.backTickMatchPattern());
    }

    private boolean setParameterIfItMatchesPattern(@Nonnull String argString, Pattern pattern, BiPredicate<String, Matcher> matchingFunction) throws CommandException {
        Matcher matcher = pattern.matcher(argString);
        if (matchingFunction.test(argString, matcher)) {
            this.parameterMap.setParameter(matcher.group("key"), matcher.group("value"));
            return true;
        }
        return false;
    }

    private BiPredicate<String, Matcher> assignIfValidParameter() {
        return (argString, matcher) -> matcher.matches();
    }

    private BiPredicate<String, Matcher> backTickMatchPattern() {
        return (argString, backtickLambdaMatcher) -> argString.trim().startsWith("`") && backtickLambdaMatcher.matches() && backtickLambdaMatcher.group("key").length() > 2;
    }
}

