/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import javax.annotation.Nonnull;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.log.Logger;

public class StringShellRunner
implements ShellRunner {
    private final String cypher;
    private final Logger logger;
    private final StatementExecuter executer;

    public StringShellRunner(@Nonnull CliArgs cliArgs, @Nonnull StatementExecuter executer, @Nonnull Logger logger) {
        this.executer = executer;
        this.logger = logger;
        if (!cliArgs.isStringShell()) {
            throw new NullPointerException("No cypher string specified");
        }
        this.cypher = cliArgs.getCypher().get();
    }

    @Override
    public int runUntilEnd() {
        int exitCode = 0;
        try {
            this.executer.execute(this.cypher.trim());
        }
        catch (Throwable t) {
            this.logger.printError(t);
            exitCode = 1;
        }
        return exitCode;
    }

    @Override
    @Nonnull
    public Historian getHistorian() {
        return Historian.empty;
    }
}

