/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.printer;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.shell.cli.ErrorFormat;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.exception.AnsiFormattedException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AnsiPrinter
implements Printer {
    private static final String ERROR_50N42 = "50N42";
    private static final Logger log = Logger.create();
    private static final List<String> TRIM_STATUS_DESC_START = List.of("error: ", "warn: ", "info: ");
    private final PrintStream out;
    private final PrintStream err;
    private final ErrorFormat errorFormat;
    private Format format;

    public AnsiPrinter(Format format, ErrorFormat errorFormat, PrintStream out, PrintStream err) {
        this.format = format;
        this.out = out;
        this.err = err;
        this.errorFormat = errorFormat;
        try {
            if (AnsiPrinter.isOutputInteractive()) {
                Ansi.setEnabled((boolean)true);
                AnsiConsole.systemInstall();
            } else {
                Ansi.setEnabled((boolean)false);
            }
        }
        catch (Throwable t) {
            log.warn("Not running on a distro with standard c library, disabling Ansi", t);
            Ansi.setEnabled((boolean)false);
        }
    }

    private static Throwable getRootCause(Throwable th) {
        Throwable cause = th;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static boolean isOutputInteractive() {
        return 1 == CLibrary.isatty((int)CLibrary.STDOUT_FILENO) && 1 == CLibrary.isatty((int)CLibrary.STDERR_FILENO);
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public void printError(Throwable throwable) {
        this.printError(this.getFormattedMessage(throwable));
    }

    @Override
    public void printError(String s) {
        this.err.println(s);
    }

    @Override
    public void printOut(String msg) {
        this.out.println(msg);
    }

    public String getFormattedMessage(Throwable e) {
        Neo4jException driverException;
        AnsiFormattedText msg = AnsiFormattedText.s().brightRed();
        if (e instanceof AnsiFormattedException) {
            AnsiFormattedException ae = (AnsiFormattedException)e;
            msg.append(ae.getFormattedMessage());
        } else if (e instanceof ClientException && e.getMessage() != null && e.getMessage().contains("Missing username")) {
            msg.append(e.getMessage()).append("\nPlease specify --username, and optionally --password, as argument(s)").append("\nor as environment variable(s), NEO4J_USERNAME, and NEO4J_PASSWORD respectively.").append("\nSee --help for more info.");
        } else if (this.errorFormat == ErrorFormat.GQL && e instanceof Neo4jException && !ERROR_50N42.equals((driverException = (Neo4jException)e).gqlStatus())) {
            boolean first = true;
            for (Neo4jException gqlError : AnsiPrinter.collectGqlExceptions(driverException)) {
                if (!first) {
                    msg.append("  ");
                }
                msg.append(gqlError.gqlStatus()).append(": ").append(AnsiPrinter.trimStatusDesc(gqlError.statusDescription())).append(System.lineSeparator());
                first = false;
            }
        } else if (this.errorFormat == ErrorFormat.STACKTRACE) {
            msg.append(Exceptions.stringify((Throwable)e));
        } else {
            Throwable cause = e;
            if (e instanceof ServiceUnavailableException) {
                Throwable[] suppressed;
                for (Throwable s : suppressed = e.getSuppressed()) {
                    if (!(s instanceof DiscoveryException)) continue;
                    cause = AnsiPrinter.getRootCause(s);
                    break;
                }
            }
            if (cause.getMessage() != null) {
                msg.append(cause.getMessage());
            } else {
                msg.append(cause.getClass().getSimpleName());
            }
        }
        return msg.resetAndRender();
    }

    private static List<Neo4jException> collectGqlExceptions(Neo4jException e) {
        ArrayList<Neo4jException> exceptionsWithCauses = new ArrayList<Neo4jException>();
        while (e != null) {
            exceptionsWithCauses.add(e);
            e = e.gqlCause().orElse(null);
        }
        return exceptionsWithCauses.reversed();
    }

    private static String trimStatusDesc(String in) {
        for (String toTrim : TRIM_STATUS_DESC_START) {
            if (!in.startsWith(toTrim)) continue;
            return in.substring(toTrim.length());
        }
        return in;
    }
}

