/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.completions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.shell.completions.DbInfo;
import org.neo4j.shell.completions.QueryPoller;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.state.BoltStateHandler;
import org.neo4j.shell.util.Version;
import org.neo4j.shell.util.Versions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbInfoImpl
extends DbInfo {
    private static final Logger log = Logger.create();
    final BoltStateHandler boltStateHandler;
    final boolean completionsEnabledByConfig;
    QueryPoller queryPoller;

    private void initializeQueryPoller() {
        this.queryPoller = new QueryPoller(this.boltStateHandler);
        QueryPoller.PollingQuery fetchDataSummary = new QueryPoller.PollingQuery(QueryPoller.FETCH_DATA_SUMMARY, records -> {
            this.labels = ((Record)records.get(0)).get("result").asList(Value::asString);
            this.relationshipTypes = ((Record)records.get(1)).get("result").asList(Value::asString);
            this.propertyKeys = ((Record)records.get(2)).get("result").asList(Value::asString);
        });
        QueryPoller.PollingQuery fetchDatabases = new QueryPoller.PollingQuery("SHOW DATABASES YIELD *;", records -> {
            this.databaseNames = records.stream().map(r -> r.get("name").asString()).toList();
            this.aliasNames = records.stream().flatMap(r -> r.get("aliases").asList(Value::toString).stream().map(alias -> {
                if (alias.startsWith("\"") && alias.endsWith("\"")) {
                    return alias.substring(1, alias.length() - 1);
                }
                return alias;
            })).toList();
            String currentDb = this.boltStateHandler.connectionConfig().database();
            records.forEach(r -> {
                String dbName = r.get("name").asString();
                if (Objects.equals(dbName, currentDb)) {
                    String defaultVersion = r.get("defaultLanguage").asString();
                    Arrays.asList(CypherVersion.values()).forEach(v -> {
                        if (defaultVersion.equals(v.description)) {
                            this.defaultLanguage = v;
                        }
                    });
                }
            });
        });
        Arrays.asList(CypherVersion.values()).forEach(v -> {
            this.procedures.put(v, new ConcurrentHashMap());
            this.functions.put(v, List.of());
        });
        List<QueryPoller.PollingQuery> fetchProcedures = Arrays.stream(CypherVersion.values()).map(this::getFetchProcedures).toList();
        QueryPoller.PollingQuery fetchProceduresLegacy = this.getFetchProcedures(null);
        List<QueryPoller.PollingQuery> fetchFunctions = Arrays.stream(CypherVersion.values()).map(this::getFetchFunctions).toList();
        QueryPoller.PollingQuery fetchFunctionsLegacy = this.getFetchFunctions(null);
        QueryPoller.PollingQuery fetchRoles = new QueryPoller.PollingQuery("SHOW ROLES YIELD role;", records -> {
            this.roleNames = records.stream().map(r -> r.get("role").asString()).toList();
        });
        QueryPoller.PollingQuery fetchUsers = new QueryPoller.PollingQuery("SHOW USERS YIELD user;", records -> {
            this.userNames = records.stream().map(r -> r.get("user").asString()).toList();
        });
        List<QueryPoller.PollingQuery> legacyFunctionAndProcedurePolling = List.of(fetchProceduresLegacy, fetchFunctionsLegacy);
        List<QueryPoller.PollingQuery> versionedFunctionAndProcedurePolling = Stream.concat(fetchProcedures.stream(), fetchFunctions.stream()).toList();
        this.queryPoller.startPolling(fetchDatabases, legacyFunctionAndProcedurePolling, versionedFunctionAndProcedurePolling, fetchDataSummary, fetchRoles, fetchUsers);
    }

    private QueryPoller.PollingQuery getFetchProcedures(CypherVersion version) {
        String parserPrepend = version != null ? version.description + " " : "";
        CypherVersion resolvedCypherVersion = version != null ? version : CypherVersion.Cypher5;
        return new QueryPoller.PollingQuery(parserPrepend + "SHOW PROCEDURES YIELD name, returnDescription", records -> {
            this.procedures.keySet().forEach(v -> this.procedures.put(v, new ConcurrentHashMap()));
            for (Record record : records) {
                String procedureName = record.get("name").asString();
                List returnDescription = record.get("returnDescription").asList(x -> new DbInfo.ReturnDescription(x.get("name").asString()));
                ((Map)this.procedures.get(resolvedCypherVersion)).put(procedureName, new DbInfo.Neo4jProcedure(returnDescription));
            }
        });
    }

    private QueryPoller.PollingQuery getFetchFunctions(CypherVersion version) {
        String parserPrepend = version != null ? version.description + " " : "";
        CypherVersion resolvedCypherVersion = version != null ? version : CypherVersion.Cypher5;
        return new QueryPoller.PollingQuery(parserPrepend + "SHOW FUNCTIONS YIELD name", records -> this.functions.put(resolvedCypherVersion, records.stream().map(r -> r.get("name").asString()).toList()));
    }

    public DbInfoImpl(ParameterService parameterService, BoltStateHandler boltStateHandler, boolean completionsEnabledByConfig) {
        super(parameterService);
        this.completionsEnabledByConfig = completionsEnabledByConfig;
        this.boltStateHandler = boltStateHandler;
        if (this.completionsEnabled()) {
            this.initializeQueryPoller();
        }
    }

    @Override
    public boolean completionsEnabled() {
        if (this.completionsEnabledByConfig && this.versionCompatibleWithCompletions.isEmpty() && this.boltStateHandler.isConnected()) {
            try {
                Version serverVersion = Versions.version(this.boltStateHandler.getServerVersion());
                boolean enableCompletions = serverVersion.compareTo(Versions.version("5.0.0")) >= 0;
                this.versionCompatibleWithCompletions = Optional.of(enableCompletions);
            }
            catch (Versions.FailedToParseException e) {
                log.warn("Failed to parse server version", e);
            }
        }
        return this.versionCompatibleWithCompletions.orElse(false);
    }

    @Override
    public void resumePolling() {
        if (this.queryPoller != null) {
            this.queryPoller.resumePolling();
        } else if (this.completionsEnabled()) {
            this.initializeQueryPoller();
        }
    }

    @Override
    public void stopPolling() {
        if (this.queryPoller != null) {
            this.queryPoller.stopPolling();
        }
    }

    @Override
    public void close() throws Exception {
        this.cleanDbInfo();
        if (this.queryPoller != null) {
            this.queryPoller.close();
            this.queryPoller = null;
        }
    }
}

