/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.completions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ast.factory.neo4j.completion.CodeCompletionCore;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.v25.Cypher25Lexer;
import org.neo4j.cypher.internal.parser.v25.Cypher25Parser;
import org.neo4j.cypher.internal.parser.v25.ast.factory.Cypher25AstLexer;
import org.neo4j.cypher.internal.preparser.CypherPreparserLexer;
import org.neo4j.cypher.internal.preparser.CypherPreparserParser;
import org.neo4j.cypher.internal.preparser.PreparserCypherLexer;
import org.neo4j.shell.completions.DbInfo;
import org.neo4j.shell.completions.Suggestion;
import org.neo4j.shell.completions.SuggestionType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CompletionEngine {
    DbInfo dbInfo;

    public CypherVersion resolveCypherVersion(CypherVersion parsedVersion) {
        return parsedVersion != null ? parsedVersion : (this.dbInfo.defaultLanguage != null ? this.dbInfo.defaultLanguage : CypherVersion.Cypher5);
    }

    public CompletionEngine(DbInfo dbInfo) {
        this.dbInfo = dbInfo;
    }

    private PreParserInfo getPreParserInfo(String incompleteQuery) throws IOException {
        PreparserCypherLexer preLexer = PreparserCypherLexer.fromString((String)incompleteQuery, (boolean)true);
        CommonTokenStream preparserTokenStream = new CommonTokenStream((TokenSource)preLexer);
        CypherPreparserParser preparser = new CypherPreparserParser((TokenStream)preparserTokenStream);
        preLexer.removeErrorListeners();
        preparser.removeErrorListeners();
        VersionCollector versionCollector = new VersionCollector(this);
        preparser.addParseListener((ParseTreeListener)versionCollector);
        CypherPreparserParser.StrictlyPreparserOptionsContext preparserCtx = preparser.strictlyPreparserOptions();
        preparserTokenStream.seek(0);
        CypherPreparserParser.StatementContext preparserStmt = preparser.preparserOptions().statement();
        List preparserTokens = preparserTokenStream.getTokens();
        return new PreParserInfo(preparser, preparserCtx, preparserTokens, preparserStmt, versionCollector.version);
    }

    private ParserInfo getParserInfo(String incompleteQuery, CypherPreparserParser.StatementContext preparserStmt) throws IOException {
        Optional<Integer> stmtPos = Optional.ofNullable(preparserStmt).map(x -> x.start).map(Token::getStartIndex);
        String cypherStmt = stmtPos.map(incompleteQuery::substring).orElse("");
        Cypher25AstLexer lexer = Cypher25AstLexer.fromString((String)cypherStmt, (boolean)true);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        Cypher25Parser parser = new Cypher25Parser((TokenStream)tokenStream);
        VariableCollector variableCollector = new VariableCollector(this, (TokenStream)tokenStream);
        parser.addParseListener((ParseTreeListener)variableCollector);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        Cypher25Parser.StatementsContext parserCtx = parser.statements();
        List tokens = tokenStream.getTokens();
        return new ParserInfo(parser, parserCtx, variableCollector, tokens);
    }

    private CompletionResolution resolveCompletionWork(String incompleteQuery) throws IOException {
        PreParserInfo preparserInfo = this.getPreParserInfo(incompleteQuery);
        ParserInfo parserInfo = this.getParserInfo(incompleteQuery, preparserInfo.preparserStmt);
        if (preparserInfo.preparser.getNumberOfSyntaxErrors() == 0) {
            return new CompletionResolution(parserInfo, preparserInfo, true, true);
        }
        if (preparserInfo.preparserStmt == null) {
            return new CompletionResolution(parserInfo, preparserInfo, true, false);
        }
        if (parserInfo.parserCtx.statement().stream().anyMatch(statement -> statement.regularQuery() != null)) {
            return new CompletionResolution(parserInfo, preparserInfo, false, true);
        }
        return new CompletionResolution(parserInfo, preparserInfo, true, true);
    }

    public List<Suggestion> completeQuery(String incompleteQuery) throws IOException {
        CompletionResolution completionResolution = this.resolveCompletionWork(incompleteQuery);
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (completionResolution.completeWithParser) {
            List<Suggestion> parserCompletions = this.completeStatement(completionResolution.parserInfo.parser, completionResolution.parserInfo.parserCtx, completionResolution.parserInfo.tokens, completionResolution.parserInfo.variableCollector.variables, completionResolution.preparserInfo.parsedVersion);
            suggestions.addAll(parserCompletions);
        }
        if (completionResolution.completeWithPreparser) {
            List<Suggestion> preparserCompletions = this.completePreparser(completionResolution.preparserInfo.preparser, completionResolution.preparserInfo.preparserCtx, completionResolution.preparserInfo.preparserTokens, completionResolution.preparserInfo.parsedVersion);
            suggestions.addAll(preparserCompletions);
        }
        return suggestions.stream().toList();
    }

    private List<Suggestion> complete(Parser parser, Set<Integer> ignoredTokens, int caretIndex, List<String> collectedVariables, CypherVersion parsedVersion, List<Token> tokens, ParserRuleContext stopNode) {
        boolean isPreParserCompletion = parser instanceof CypherPreparserParser;
        Set<Integer> parserPreferredRules = isPreParserCompletion ? PreParserInfo.preferredRules : ParserInfo.preferredRules;
        CodeCompletionCore completionEngine = new CodeCompletionCore(parser, parserPreferredRules, ignoredTokens);
        CodeCompletionCore.CandidatesCollection candidates = completionEngine.collectCandidates(caretIndex, null);
        List<Suggestion> tokenCompletions = this.getTokenCompletions(candidates, ignoredTokens, isPreParserCompletion);
        List ruleCompletions = isPreParserCompletion ? List.of() : this.getRuleCompletions(candidates, collectedVariables, parsedVersion, tokens, stopNode);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        result.addAll(tokenCompletions);
        result.addAll(ruleCompletions);
        return result;
    }

    private Set<Integer> getIgnoredTokens(boolean forPreParser) {
        Set<Integer> keywords;
        int endToken;
        int startToken;
        if (forPreParser) {
            startToken = -1;
            endToken = PreParserInfo.vocabulary.getMaxTokenType();
            keywords = PreParserInfo.keywords;
        } else {
            startToken = -1;
            endToken = ParserInfo.vocabulary.getMaxTokenType();
            keywords = ParserInfo.keywords;
        }
        return IntStream.rangeClosed(startToken, endToken).filter(i -> !keywords.contains(i)).boxed().collect(Collectors.toSet());
    }

    private int getCaretIndex(List<Token> tokens, boolean forPreParser) {
        Token previousToken;
        int caretIndex = tokens.size() - 1;
        Token token = previousToken = tokens.size() > 1 ? tokens.get(caretIndex - 1) : null;
        if (previousToken != null) {
            boolean previousIsLexerKeyword;
            boolean previousIsIdentifier;
            if (forPreParser) {
                previousIsIdentifier = previousToken.getType() == 9;
                previousIsLexerKeyword = PreParserInfo.keywords.contains(previousToken.getType());
            } else {
                previousIsIdentifier = previousToken.getType() == 307;
                previousIsLexerKeyword = ParserInfo.keywords.contains(previousToken.getType());
            }
            if (previousIsIdentifier || previousIsLexerKeyword) {
                --caretIndex;
            }
        }
        return caretIndex;
    }

    private List<Suggestion> completePreparser(CypherPreparserParser preparser, CypherPreparserParser.StrictlyPreparserOptionsContext rootCtx, List<Token> tokens, CypherVersion parsedVersion) {
        ParserRuleContext stopNode = this.findStopNode((ParserRuleContext)rootCtx, rootCtx.EOF());
        int caretIndex = this.getCaretIndex(tokens, true);
        Set<Integer> ignoredTokens = this.getIgnoredTokens(true);
        return this.complete((Parser)preparser, ignoredTokens, caretIndex, List.of(), parsedVersion, tokens, stopNode);
    }

    private List<Suggestion> completeStatement(Cypher25Parser parser, Cypher25Parser.StatementsContext rootCtx, List<Token> tokens, List<String> collectedVariables, CypherVersion parsedVersion) {
        ParserRuleContext stopNode = this.findStopNode((ParserRuleContext)rootCtx, rootCtx.EOF());
        int caretIndex = this.getCaretIndex(tokens, false);
        Set<Integer> ignoredTokens = this.getIgnoredTokens(false);
        return this.complete((Parser)parser, ignoredTokens, caretIndex, collectedVariables, parsedVersion, tokens, stopNode);
    }

    private static String backtickIfNeeded(String e) {
        if (e == null || e.isEmpty()) {
            return e;
        }
        Pattern invalidStartPattern = Pattern.compile("^[^\\p{L}_]", 256);
        Pattern invalidAnywherePattern = Pattern.compile("[^\\p{L}\\p{N}_]", 256);
        Matcher m1 = invalidStartPattern.matcher(String.valueOf(e.charAt(0)));
        Matcher m2 = invalidAnywherePattern.matcher(e);
        if (m1.find() || m2.find()) {
            return "`" + e + "`";
        }
        return e;
    }

    private static String backtickDbNameIfNeeded(String e) {
        if (e == null || e.isEmpty()) {
            return e;
        }
        Pattern invalidStartPattern = Pattern.compile("^[^\\p{L}_]", 256);
        Pattern invalidAnywherePattern = Pattern.compile("[^\\p{L}\\p{N}_.]", 256);
        Matcher m1 = invalidStartPattern.matcher(String.valueOf(e.charAt(0)));
        Matcher m2 = invalidAnywherePattern.matcher(e);
        if (m1.find() || m2.find()) {
            return "`" + e + "`";
        }
        return e;
    }

    private Stream<Suggestion> labelCompletions() {
        return this.dbInfo.labels.stream().map(label -> Suggestion.labelOrRelType(CompletionEngine.backtickIfNeeded(label), label));
    }

    private Stream<Suggestion> relTypeCompletions() {
        return this.dbInfo.relationshipTypes.stream().map(relType -> Suggestion.labelOrRelType(CompletionEngine.backtickIfNeeded(relType), relType));
    }

    private Stream<Suggestion> propertyKeyCompletions() {
        return this.dbInfo.propertyKeys.stream().map(property -> Suggestion.property(CompletionEngine.backtickIfNeeded(property), property));
    }

    private ParserRuleContext findStopNode(ParserRuleContext root, TerminalNode endToken) {
        List children = root.children;
        ParserRuleContext current = root;
        while (children != null && !children.isEmpty()) {
            int index = children.size() - 1;
            ParseTree child = (ParseTree)children.get(index);
            while (index > 0 && (child == endToken || child.getText().isEmpty() || child.getText().startsWith("<missing"))) {
                child = (ParseTree)children.get(--index);
            }
            if (child instanceof ParserRuleContext) {
                current = (ParserRuleContext)child;
                children = current.children;
                continue;
            }
            children = null;
        }
        return current;
    }

    private Optional<ParserRuleContext> getParent(ParserRuleContext ctx, ParserRuleContextFunction condition) {
        ParserRuleContext parentCtx;
        for (parentCtx = ctx; !condition.test(parentCtx) && parentCtx != null; parentCtx = parentCtx.getParent()) {
        }
        return Optional.ofNullable(parentCtx);
    }

    private String getMethodName(Cypher25Parser.ProcedureNameContext nameCtx) {
        List namespaces = nameCtx.namespace().symbolicNameString();
        Cypher25Parser.SymbolicNameStringContext methodName = nameCtx.symbolicNameString();
        ArrayList<Cypher25Parser.SymbolicNameStringContext> nameChunks = new ArrayList<Cypher25Parser.SymbolicNameStringContext>(namespaces);
        nameChunks.add(methodName);
        String normalizedName = nameChunks.stream().map(this::getNamespaceString).collect(Collectors.joining("."));
        return normalizedName;
    }

    private String getNamespaceString(Cypher25Parser.SymbolicNameStringContext nameCtx) {
        String text = nameCtx.getText();
        boolean isEscaped = nameCtx.escapedSymbolicNameString() != null;
        boolean hasDot = text.contains(".");
        if (isEscaped && !hasDot) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private List<Suggestion> getRuleCompletions(CodeCompletionCore.CandidatesCollection candidates, List<String> collectedVariables, CypherVersion parsedVersion, List<Token> tokens, ParserRuleContext stopNode) {
        return candidates.rules.entrySet().stream().flatMap(entry -> {
            Integer ruleNumber = (Integer)entry.getKey();
            CodeCompletionCore.CandidateRule candidateRule = (CodeCompletionCore.CandidateRule)entry.getValue();
            int startTokenIndex = candidateRule.startTokenIndex();
            List ruleList = candidateRule.ruleList();
            if (ruleNumber == 43) {
                Optional<ParserRuleContext> callClause = this.getParent(stopNode, x -> x instanceof Cypher25Parser.CallClauseContext);
                if (callClause.isPresent()) {
                    Cypher25Parser.CallClauseContext call = (Cypher25Parser.CallClauseContext)callClause.get();
                    String procName = this.getMethodName(call.procedureName());
                    HashSet existingItemNames = call.procedureResultItem().stream().map(AstRuleCtx::getText).collect(Collectors.toCollection(HashSet::new));
                    return this.procedureReturnCompletions(procName, this.resolveCypherVersion(parsedVersion)).filter(a -> !existingItemNames.contains(a.value()));
                }
            } else {
                if (ruleNumber == 140) {
                    return this.functionNameCompletions(startTokenIndex, tokens, this.resolveCypherVersion(parsedVersion));
                }
                if (ruleNumber == 41) {
                    return this.procedureNameCompletions(startTokenIndex, tokens, this.resolveCypherVersion(parsedVersion));
                }
                if (ruleNumber == 136) {
                    return this.parameterCompletions(this.inferExpectedParameterTypeFromContext(candidateRule));
                }
                if (ruleNumber == 135) {
                    String variableName;
                    ParserRuleContext expr2;
                    Integer parentRule = (Integer)ruleList.get(ruleList.size() - 1);
                    Integer grandParentRule = (Integer)ruleList.get(ruleList.size() - 2);
                    if (parentRule == 328 && grandParentRule == 111) {
                        return Stream.empty();
                    }
                    Integer greatGrandParentRule = (Integer)ruleList.get(ruleList.size() - 3);
                    if (parentRule == 106 && grandParentRule == 105 && greatGrandParentRule == 104 && (expr2 = stopNode.getParent().getParent().getParent()) instanceof Cypher25Parser.Expression2Context && ((variableName = ((Cypher25Parser.Expression2Context)expr2).expression1().variable().getText()) == null || collectedVariables.contains(variableName))) {
                        return Stream.empty();
                    }
                    return this.propertyKeyCompletions();
                }
                if (ruleNumber == 142) {
                    Integer parentRule;
                    if (!ruleList.isEmpty() && !ParserInfo.rulesDefiningVariables.contains(parentRule = (Integer)ruleList.get(ruleList.size() - 1))) {
                        return collectedVariables.stream().map(Suggestion::identifier);
                    }
                } else if (ruleNumber == 89) {
                    int topExprIndex = ruleList.indexOf(85);
                    if (topExprIndex > 0) {
                        Integer topExprParent = (Integer)ruleList.get(topExprIndex - 1);
                        if (topExprParent == 67) {
                            return this.labelCompletions();
                        }
                        if (topExprParent == 79) {
                            return this.relTypeCompletions();
                        }
                        return Stream.concat(this.labelCompletions(), this.relTypeCompletions());
                    }
                } else {
                    if (ruleNumber == 320) {
                        return this.completeAliasName(tokens, candidateRule, startTokenIndex);
                    }
                    if (ruleNumber == 316) {
                        return this.completeSymbolicName(candidateRule, tokens, startTokenIndex);
                    }
                }
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private ParameterType inferExpectedParameterTypeFromContext(CodeCompletionCore.CandidateRule candidateRule) {
        List ruleList = candidateRule.ruleList();
        Integer parentRule = (Integer)ruleList.get(ruleList.size() - 1);
        if (Set.of(325, 316, 315, 317, 319, 226, 218, 219, 222, 220, 212, 213, 201, 202, 214).contains(parentRule)) {
            return ParameterType.STRING;
        }
        if (Set.of(Integer.valueOf(78), Integer.valueOf(327)).contains(parentRule)) {
            return ParameterType.MAP;
        }
        return ParameterType.ANY;
    }

    private Optional<Token> findPreviousNonSpace(List<Token> tokens, int index) {
        int i = index;
        while (i > 0) {
            Token token;
            if ((token = tokens.get(--i)).getType() == 1) continue;
            return Optional.of(token);
        }
        return Optional.empty();
    }

    private Stream<Suggestion> completeSymbolicName(CodeCompletionCore.CandidateRule candidateRule, List<Token> tokens, int ruleStartTokenIndex) {
        Stream<Suggestion> parameterSuggestions = this.parameterCompletions(this.inferExpectedParameterTypeFromContext(candidateRule));
        List ruleList = candidateRule.ruleList();
        List<Integer> rulesCreatingNewUserOrRole = List.of(Integer.valueOf(218), Integer.valueOf(212));
        Optional<Token> previousToken = this.findPreviousNonSpace(tokens, ruleStartTokenIndex);
        boolean afterToToken = previousToken.stream().anyMatch(t -> t.getType() == 273);
        if (rulesCreatingNewUserOrRole.stream().anyMatch(ruleList::contains) || candidateRule.ruleList().contains(220) && afterToToken) {
            return parameterSuggestions;
        }
        List<Integer> rulesThatAcceptExistingUsers = List.of(Integer.valueOf(219), Integer.valueOf(220), Integer.valueOf(222), Integer.valueOf(201));
        if (rulesThatAcceptExistingUsers.stream().anyMatch(ruleList::contains)) {
            return Stream.concat(parameterSuggestions, this.dbInfo.userNames.stream().map(Suggestion::value));
        }
        List<Integer> rulesThatAcceptExistingRoles = List.of(Integer.valueOf(202), Integer.valueOf(213), Integer.valueOf(214));
        if (rulesThatAcceptExistingRoles.stream().anyMatch(ruleList::contains)) {
            return Stream.concat(parameterSuggestions, this.dbInfo.roleNames.stream().map(Suggestion::value));
        }
        return Stream.empty();
    }

    private Stream<Suggestion> completeAliasName(List<Token> tokens, CodeCompletionCore.CandidateRule candidateRule, int ruleStartTokenIndex) {
        List ruleList = candidateRule.ruleList();
        if (ruleStartTokenIndex + 1 < tokens.size() && tokens.get(ruleStartTokenIndex + 1).getType() == 1) {
            return Stream.empty();
        }
        Stream<Suggestion> parameterSuggestions = this.parameterCompletions(ParameterType.STRING);
        List<Integer> rulesCreatingNewDb = List.of(Integer.valueOf(286), Integer.valueOf(285));
        if (rulesCreatingNewDb.stream().anyMatch(ruleList::contains)) {
            return parameterSuggestions;
        }
        if (ruleList.contains(306) && ruleList.contains(303)) {
            return parameterSuggestions;
        }
        List<Integer> rulesThatOnlyAcceptAlias = List.of(Integer.valueOf(307), Integer.valueOf(308), Integer.valueOf(314));
        if (rulesThatOnlyAcceptAlias.stream().anyMatch(ruleList::contains)) {
            return Stream.concat(parameterSuggestions, this.dbInfo.aliasNames.stream().map(name -> Suggestion.value(CompletionEngine.backtickDbNameIfNeeded(name), name)));
        }
        return Stream.concat(Stream.concat(parameterSuggestions, this.dbInfo.databaseNames.stream().map(name -> Suggestion.value(CompletionEngine.backtickDbNameIfNeeded(name), name))), this.dbInfo.aliasNames.stream().map(name -> Suggestion.value(CompletionEngine.backtickDbNameIfNeeded(name), name)));
    }

    private String calculateNamespacePrefix(int startTokenIndex, List<Token> tokens) {
        boolean lastNonSpaceIsDot;
        List<Token> ruleTokens = tokens.subList(startTokenIndex, tokens.size() - 1);
        Token lastNonEOFToken = ruleTokens.size() >= 2 ? ruleTokens.get(ruleTokens.size() - 2) : null;
        ArrayList<Token> nonSpaceTokens = new ArrayList<Token>(ruleTokens.stream().filter(token -> token.getType() != 1 && token.getType() != -1).toList());
        boolean bl = lastNonSpaceIsDot = !nonSpaceTokens.isEmpty() && nonSpaceTokens.get(nonSpaceTokens.size() - 1).getType() == 80;
        if (lastNonEOFToken != null && lastNonEOFToken.getType() == 1 && !lastNonSpaceIsDot) {
            return null;
        }
        if (!lastNonSpaceIsDot && !nonSpaceTokens.isEmpty()) {
            nonSpaceTokens.remove(nonSpaceTokens.size() - 1);
        }
        String namespacePrefix = nonSpaceTokens.stream().map(Token::getText).collect(Collectors.joining(""));
        return namespacePrefix;
    }

    private Stream<Suggestion> functionNameCompletions(int ruleStartTokenIndex, List<Token> tokens, CypherVersion cypherVersion) {
        return this.namespacedCompletion(ruleStartTokenIndex, tokens, this.dbInfo.functions.get(cypherVersion), SuggestionType.FUNCTION);
    }

    private Stream<Suggestion> procedureNameCompletions(int ruleStartTokenIndex, List<Token> tokens, CypherVersion cypherVersion) {
        return this.namespacedCompletion(ruleStartTokenIndex, tokens, this.dbInfo.procedures.get(cypherVersion).keySet().stream().toList(), SuggestionType.PROCEDURE);
    }

    private Stream<Suggestion> procedureReturnCompletions(String procedureName, CypherVersion cypherVersion) {
        DbInfo.Neo4jProcedure procedure = this.dbInfo.procedures.get(cypherVersion).get(procedureName);
        if (procedure != null) {
            Stream<String> procedureReturns = procedure.returnDescription().stream().map(DbInfo.ReturnDescription::name);
            return procedureReturns.map(Suggestion::identifier);
        }
        return Stream.of(new Suggestion[0]);
    }

    private Stream<Suggestion> getNamespaceSuggestions(Stream<String> namespaces, SuggestionType suggestionType) {
        return namespaces.map(completion -> {
            if (suggestionType == SuggestionType.FUNCTION) {
                return Suggestion.functionNamespace(completion);
            }
            return Suggestion.procedureNamespace(completion);
        }).collect(Collectors.toSet()).stream();
    }

    private Stream<Suggestion> getFullNameSuggestions(Stream<String> fullNames, SuggestionType suggestionType) {
        return fullNames.map(completion -> {
            if (suggestionType == SuggestionType.FUNCTION) {
                return Suggestion.function(completion);
            }
            return Suggestion.procedure(completion);
        });
    }

    private Stream<Suggestion> namespacedCompletion(int ruleStartTokenIndex, List<Token> tokens, List<String> signatures, SuggestionType suggestionType) {
        HashSet<String> fullNames = new HashSet<String>(signatures);
        String namespacePrefix = this.calculateNamespacePrefix(ruleStartTokenIndex, tokens);
        if (namespacePrefix == null) {
            return Stream.empty();
        }
        if (namespacePrefix.isEmpty()) {
            Stream<String> topLevelPrefixes = fullNames.stream().filter(fn -> fn.contains(".")).map(fnName -> fnName.split("\\.")[0]);
            Stream<Suggestion> namespaceCompletions = this.getNamespaceSuggestions(topLevelPrefixes, suggestionType);
            Stream<Suggestion> fullNameCompletions = this.getFullNameSuggestions(fullNames.stream(), suggestionType);
            return Stream.concat(namespaceCompletions, fullNameCompletions);
        }
        HashSet<String> fullNameOptions = new HashSet<String>();
        HashSet<String> namespaceOptions = new HashSet<String>();
        for (String name : fullNames) {
            boolean isFunctionName;
            if (!name.startsWith(namespacePrefix)) continue;
            String[] splitByDot = name.substring(namespacePrefix.length()).split("\\.");
            String option = splitByDot[0];
            boolean bl = isFunctionName = splitByDot.length == 1;
            if (option.isEmpty()) continue;
            if (isFunctionName) {
                fullNameOptions.add(option);
                continue;
            }
            namespaceOptions.add(option);
        }
        Stream<Suggestion> namespaceCompletions = this.getNamespaceSuggestions(namespaceOptions.stream(), suggestionType);
        Stream<Suggestion> fullNameCompletions = this.getFullNameSuggestions(fullNameOptions.stream(), suggestionType);
        return Stream.concat(namespaceCompletions, fullNameCompletions);
    }

    private Stream<Suggestion> parameterCompletions(ParameterType expectedType) {
        Stream<Suggestion> result = this.dbInfo.parameters().entrySet().stream().filter(entry -> expectedType == ParameterType.ANY || entry.getValue() == expectedType).map(parameter -> Suggestion.parameter("$" + CompletionEngine.backtickIfNeeded((String)parameter.getKey()), "$" + (String)parameter.getKey()));
        return result;
    }

    private String getTokenName(int token, boolean usePreparserTokens) {
        if (usePreparserTokens) {
            return PreParserInfo.vocabulary.getDisplayName(token);
        }
        if (ParserInfo.customTokenDisplayNames.containsKey(token)) {
            return ParserInfo.customTokenDisplayNames.get(token);
        }
        return ParserInfo.vocabulary.getDisplayName(token);
    }

    private List<Suggestion> getTokenCompletions(CodeCompletionCore.CandidatesCollection candidates, Set<Integer> ignoredTokens, boolean usePreparserTokens) {
        Set tokenEntries = candidates.tokens.entrySet();
        Stream<Suggestion> completions = tokenEntries.stream().flatMap(value -> {
            Integer tokenNumber = (Integer)value.getKey();
            List followUpList = (List)value.getValue();
            if (!ignoredTokens.contains(tokenNumber) && tokenNumber >= -1) {
                String firstToken = this.getTokenName(tokenNumber, usePreparserTokens);
                int lastIndexToSlice = followUpList.size();
                for (int i = 0; i < followUpList.size() && lastIndexToSlice == followUpList.size(); ++i) {
                    if (!ignoredTokens.contains(followUpList.get(i))) continue;
                    lastIndexToSlice = i;
                }
                List followUpTokens = followUpList.subList(0, lastIndexToSlice);
                String followUpString = followUpTokens.stream().map(token -> this.getTokenName((int)token, usePreparserTokens)).collect(Collectors.joining("  "));
                if (!followUpString.isEmpty()) {
                    return Stream.of(firstToken + " " + followUpString);
                }
                return Stream.of(firstToken);
            }
            return Stream.of(new String[0]);
        });
        List<Suggestion> result = completions.map(Suggestion::keyword).collect(Collectors.toList());
        return result;
    }

    public boolean completionsEnabled() {
        return this.dbInfo.completionsEnabled();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class VersionCollector
    implements ParseTreeListener {
        private CypherVersion version = null;

        VersionCollector(CompletionEngine this$0) {
        }

        public void visitTerminal(TerminalNode node) {
        }

        public void visitErrorNode(ErrorNode node) {
        }

        public void enterEveryRule(ParserRuleContext ctx) {
        }

        public void exitEveryRule(ParserRuleContext ctx) {
            CypherPreparserParser.OptionContext c;
            if (ctx.getRuleIndex() == 2 && (c = (CypherPreparserParser.OptionContext)ctx).VERSION() != null) {
                Arrays.stream(CypherVersion.values()).forEach(version -> {
                    if (Objects.equals(version.versionName, c.VERSION().getText())) {
                        this.version = version;
                    }
                });
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record PreParserInfo(CypherPreparserParser preparser, CypherPreparserParser.StrictlyPreparserOptionsContext preparserCtx, List<Token> preparserTokens, CypherPreparserParser.StatementContext preparserStmt, CypherVersion parsedVersion) {
        static Vocabulary vocabulary = PreparserCypherLexer.VOCABULARY;
        static Set<Integer> keywords = new HashSet<Integer>();
        static Set<Integer> preferredRules;

        static {
            Set<Integer> ignoreFromPreparserLexer = Set.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(-1), Integer.valueOf(2), Integer.valueOf(9), Integer.valueOf(4), Integer.valueOf(3));
            for (int i = 0; i < CypherPreparserLexer.VOCABULARY.getMaxTokenType(); ++i) {
                if (vocabulary.getLiteralName(i) != null || ignoreFromPreparserLexer.contains(i)) continue;
                keywords.add(i);
            }
            preferredRules = Set.of();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class VariableCollector
    implements ParseTreeListener {
        private final List<String> variables = new ArrayList<String>();
        TokenStream tokens;

        public VariableCollector(CompletionEngine this$0, TokenStream tokens) {
            this.tokens = tokens;
        }

        public void visitTerminal(TerminalNode node) {
        }

        public void visitErrorNode(ErrorNode node) {
        }

        public void enterEveryRule(ParserRuleContext ctx) {
        }

        public void exitEveryRule(ParserRuleContext ctx) {
            if (ctx.getRuleIndex() == 142) {
                boolean definesVariable;
                Cypher25Parser.VariableContext c = (Cypher25Parser.VariableContext)ctx;
                int tokenIndex = c.stop.getTokenIndex();
                boolean nextTokenIsEOF = tokenIndex != -1 && this.tokens.get(tokenIndex + 1).getType() == -1;
                boolean bl = definesVariable = c.getParent() != null && ParserInfo.rulesDefiningOrUsingVariables.contains(c.getParent().getRuleIndex());
                if (c.symbolicVariableNameString() != null && c.symbolicVariableNameString().getText() != null && !nextTokenIsEOF && definesVariable) {
                    String variable = c.symbolicVariableNameString().getText();
                    this.variables.add(variable);
                }
            } else if (ctx.getRuleIndex() == 43) {
                Cypher25Parser.ProcedureResultItemContext c = (Cypher25Parser.ProcedureResultItemContext)ctx;
                if (c.yieldItemName != null && c.yieldItemName.getText() != null) {
                    String variable = c.yieldItemName.getText();
                    this.variables.add(variable);
                }
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record ParserInfo(Cypher25Parser parser, Cypher25Parser.StatementsContext parserCtx, VariableCollector variableCollector, List<Token> tokens) {
        static Set<Integer> keywords;
        static Set<Integer> preferredRules;
        static Set<Integer> rulesDefiningVariables;
        static Set<Integer> rulesDefiningOrUsingVariables;
        static Map<Integer, String> customTokenDisplayNames;
        static Vocabulary vocabulary;

        static {
            preferredRules = Set.of(140, 41, 89, 320, 136, 135, 142, 81, 316, 332, 43);
            rulesDefiningVariables = Set.of(Integer.valueOf(14), Integer.valueOf(37), Integer.valueOf(52), Integer.valueOf(43), Integer.valueOf(45), Integer.valueOf(44), Integer.valueOf(119), Integer.valueOf(120), Integer.valueOf(117));
            customTokenDisplayNames = Map.of(17, "allShortestPaths", 252, "shortestPath");
            vocabulary = Cypher25Lexer.VOCABULARY;
            rulesDefiningOrUsingVariables = new HashSet<Integer>(rulesDefiningVariables);
            rulesDefiningOrUsingVariables.addAll(List.of(Integer.valueOf(56), Integer.valueOf(67), Integer.valueOf(79)));
            Set<Integer> ignoreFromLexer = Set.of(4, 5, 6, 7, 8, 9, 312, -1, 1, 307, 10, 3, 2);
            keywords = new HashSet<Integer>();
            for (int i = 0; i < Cypher25Lexer.VOCABULARY.getMaxTokenType(); ++i) {
                if (vocabulary.getLiteralName(i) != null || ignoreFromLexer.contains(i)) continue;
                keywords.add(i);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CompletionResolution(ParserInfo parserInfo, PreParserInfo preparserInfo, boolean completeWithPreparser, boolean completeWithParser) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface ParserRuleContextFunction {
        public boolean test(ParserRuleContext var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ParameterType {
        STRING,
        MAP,
        ANY;

    }
}

