/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.literal.interpreter;

import java.time.Clock;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.ParameterType;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;
import scala.util.Either;

public class LiteralInterpreter
implements ASTFactory<ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, Object, Object, Object, Object, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL> {
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    public static final String LONG_MIN_VALUE_DECIMAL_STRING = Long.toString(Long.MIN_VALUE).substring(1);
    public static final String LONG_MIN_VALUE_HEXADECIMAL_STRING = "0x" + Long.toString(Long.MIN_VALUE, 16).substring(1);
    public static final String LONG_MIN_VALUE_OCTAL_STRING_OLD_SYNTAX = "0" + Long.toString(Long.MIN_VALUE, 8).substring(1);
    public static final String LONG_MIN_VALUE_OCTAL_STRING = "0o" + Long.toString(Long.MIN_VALUE, 8).substring(1);

    public ASTFactory.NULL newSingleQuery(List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("newSingleQuery is not a literal");
    }

    public ASTFactory.NULL newUnion(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean all) {
        throw new UnsupportedOperationException("newUnion is not a literal");
    }

    public ASTFactory.NULL periodicCommitQuery(ASTFactory.NULL p, String batchSize, ASTFactory.NULL loadCsv, List<ASTFactory.NULL> aNull) {
        throw new UnsupportedOperationException("periodicCommitQuery is not a literal");
    }

    public ASTFactory.NULL useClause(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("useClause is not a literal");
    }

    public ASTFactory.NULL newReturnClause(ASTFactory.NULL p, boolean distinct, boolean returnAll, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> order, Object skip, Object limit) {
        throw new UnsupportedOperationException("newReturnClause is not a literal");
    }

    public ASTFactory.NULL newReturnItem(ASTFactory.NULL p, Object e, Object v) {
        throw new UnsupportedOperationException("newReturnItem is not a literal");
    }

    public ASTFactory.NULL newReturnItem(ASTFactory.NULL p, Object e, int eStartOffset, int eEndOffset) {
        throw new UnsupportedOperationException("newReturnItem is not a literal");
    }

    public ASTFactory.NULL orderDesc(Object e) {
        throw new UnsupportedOperationException("orderDesc is not a literal");
    }

    public ASTFactory.NULL orderAsc(Object e) {
        throw new UnsupportedOperationException("orderAsc is not a literal");
    }

    public ASTFactory.NULL withClause(ASTFactory.NULL p, ASTFactory.NULL aNull, Object where) {
        throw new UnsupportedOperationException("withClause is not a literal");
    }

    public ASTFactory.NULL matchClause(ASTFactory.NULL p, boolean optional, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> nulls2, Object where) {
        throw new UnsupportedOperationException("matchClause is not a literal");
    }

    public ASTFactory.NULL usingIndexHint(ASTFactory.NULL p, Object v, String labelOrRelType, List<String> properties, boolean seekOnly) {
        throw new UnsupportedOperationException("usingIndexHint is not a literal");
    }

    public ASTFactory.NULL usingJoin(ASTFactory.NULL p, List<Object> joinVariables) {
        throw new UnsupportedOperationException("usingJoin is not a literal");
    }

    public ASTFactory.NULL usingScan(ASTFactory.NULL p, Object v, String labelOrRelType) {
        throw new UnsupportedOperationException("usingScan is not a literal");
    }

    public ASTFactory.NULL createClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("createClause is not a literal");
    }

    public ASTFactory.NULL setClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("setClause is not a literal");
    }

    public ASTFactory.NULL setProperty(Object o, Object value) {
        throw new UnsupportedOperationException("setProperty is not a literal");
    }

    public ASTFactory.NULL setVariable(Object o, Object value) {
        throw new UnsupportedOperationException("setVariable is not a literal");
    }

    public ASTFactory.NULL addAndSetVariable(Object o, Object value) {
        throw new UnsupportedOperationException("addAndSetVariable is not a literal");
    }

    public ASTFactory.NULL setLabels(Object o, List<ASTFactory.StringPos<ASTFactory.NULL>> value) {
        throw new UnsupportedOperationException("setLabels is not a literal");
    }

    public ASTFactory.NULL removeClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("removeClause is not a literal");
    }

    public ASTFactory.NULL removeProperty(Object o) {
        throw new UnsupportedOperationException("removeProperty is not a literal");
    }

    public ASTFactory.NULL removeLabels(Object o, List<ASTFactory.StringPos<ASTFactory.NULL>> labels) {
        throw new UnsupportedOperationException("removeLabels is not a literal");
    }

    public ASTFactory.NULL deleteClause(ASTFactory.NULL p, boolean detach, List<Object> objects) {
        throw new UnsupportedOperationException("deleteClause is not a literal");
    }

    public ASTFactory.NULL unwindClause(ASTFactory.NULL p, Object e, Object v) {
        throw new UnsupportedOperationException("unwindClause is not a literal");
    }

    public ASTFactory.NULL mergeClause(ASTFactory.NULL p, ASTFactory.NULL aNull, List<ASTFactory.NULL> setClauses, List<ASTFactory.MergeActionType> actionTypes) {
        throw new UnsupportedOperationException("mergeClause is not a literal");
    }

    public ASTFactory.NULL callClause(ASTFactory.NULL p, List<String> namespace, String name, List<Object> arguments, boolean yieldAll, List<ASTFactory.NULL> nulls, Object where) {
        throw new UnsupportedOperationException("callClause is not a literal");
    }

    public ASTFactory.NULL callResultItem(ASTFactory.NULL p, String name, Object v) {
        throw new UnsupportedOperationException("callResultItem is not a literal");
    }

    public ASTFactory.NULL namedPattern(Object v, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("namedPattern is not a literal");
    }

    public ASTFactory.NULL shortestPathPattern(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("shortestPathPattern is not a literal");
    }

    public ASTFactory.NULL allShortestPathsPattern(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("allShortestPathsPattern is not a literal");
    }

    public ASTFactory.NULL everyPathPattern(List<ASTFactory.NULL> nodes, List<ASTFactory.NULL> relationships) {
        throw new UnsupportedOperationException("everyPathPattern is not a literal");
    }

    public ASTFactory.NULL nodePattern(ASTFactory.NULL p, Object v, List<ASTFactory.StringPos<ASTFactory.NULL>> labels, Object properties) {
        throw new UnsupportedOperationException("nodePattern is not a literal");
    }

    public ASTFactory.NULL relationshipPattern(ASTFactory.NULL p, boolean left, boolean right, Object v, List<ASTFactory.StringPos<ASTFactory.NULL>> relTypes, ASTFactory.NULL aNull, Object properties, boolean legacyTypeSeparator) {
        throw new UnsupportedOperationException("relationshipPattern is not a literal");
    }

    public ASTFactory.NULL pathLength(ASTFactory.NULL p, ASTFactory.NULL pMin, ASTFactory.NULL mMax, String minLength, String maxLength) {
        throw new UnsupportedOperationException("pathLength is not a literal");
    }

    public ASTFactory.NULL loadCsvClause(ASTFactory.NULL p, boolean headers, Object source, Object v, String fieldTerminator) {
        throw new UnsupportedOperationException("loadCsvClause is not a literal");
    }

    public ASTFactory.NULL foreachClause(ASTFactory.NULL p, Object v, Object list, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("foreachClause is not a literal");
    }

    public ASTFactory.NULL subqueryClause(ASTFactory.NULL p, ASTFactory.NULL subquery) {
        throw new UnsupportedOperationException("subqueryClause is not a literal");
    }

    public ASTFactory.NULL useGraph(ASTFactory.NULL aNull, ASTFactory.NULL aNull2) {
        throw new UnsupportedOperationException("useGraph is not a literal");
    }

    public ASTFactory.NULL hasCatalog(ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("hasCatalog is not a literal");
    }

    public ASTFactory.NULL createRole(ASTFactory.NULL p, boolean replace, Either<String, Object> roleName, Either<String, Object> from, boolean ifNotExists) {
        throw new UnsupportedOperationException("createRole is not a literal");
    }

    public ASTFactory.NULL dropRole(ASTFactory.NULL p, Either<String, Object> roleName, boolean ifExists) {
        throw new UnsupportedOperationException("dropRole is not a literal");
    }

    public ASTFactory.NULL renameRole(ASTFactory.NULL p, Either<String, Object> fromRoleName, Either<String, Object> toRoleName, boolean ifExists) {
        throw new UnsupportedOperationException("renameRole is not a literal");
    }

    public ASTFactory.NULL showRoles(ASTFactory.NULL p, boolean withUsers, boolean showAll, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, Object where) {
        throw new UnsupportedOperationException("showRoles is not a literal");
    }

    public ASTFactory.NULL createUser(ASTFactory.NULL p, boolean replace, boolean ifNotExists, Either<String, Object> username, Object password, boolean encrypted, boolean changeRequired, Boolean suspended, Either<String, Object> homeDatabase) {
        throw new UnsupportedOperationException("createUser is not a literal");
    }

    public ASTFactory.NULL dropUser(ASTFactory.NULL p, boolean ifExists, Either<String, Object> username) {
        throw new UnsupportedOperationException("dropUser is not a literal");
    }

    public ASTFactory.NULL renameUser(ASTFactory.NULL p, Either<String, Object> fromUserName, Either<String, Object> toUserName, boolean ifExists) {
        throw new UnsupportedOperationException("renameUser is not a literal");
    }

    public ASTFactory.NULL setOwnPassword(ASTFactory.NULL p, Object currentPassword, Object newPassword) {
        throw new UnsupportedOperationException("setOwnPassword is not a literal");
    }

    public ASTFactory.NULL alterUser(ASTFactory.NULL p, boolean ifExists, Either<String, Object> username, Object password, boolean encrypted, Boolean changeRequired, Boolean suspended, Either<String, Object> homeDatabase, boolean removeHome) {
        throw new UnsupportedOperationException("alterUser is not a literal");
    }

    public ASTFactory.NULL showUsers(ASTFactory.NULL p, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, Object where) {
        throw new UnsupportedOperationException("showUsers is not a literal");
    }

    public ASTFactory.NULL showCurrentUser(ASTFactory.NULL p, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, Object where) {
        throw new UnsupportedOperationException("showCurrentUser is not a literal");
    }

    public Object passwordExpression(Object password) {
        throw new UnsupportedOperationException("passwordExpression is not a literal");
    }

    public Object passwordExpression(ASTFactory.NULL p, String password) {
        throw new UnsupportedOperationException("passwordExpression is not a literal");
    }

    public ASTFactory.NULL yieldClause(ASTFactory.NULL p, boolean returnAll, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> orderBy, Object skip, Object limit, Object where) {
        throw new UnsupportedOperationException("yieldClause is not a literal");
    }

    public ASTFactory.NULL showIndexClause(ASTFactory.NULL p, String indexType, boolean brief, boolean verbose, Object where, boolean hasYield) {
        throw new UnsupportedOperationException("showIndexClause is not a literal");
    }

    public ASTFactory.NULL showConstraintClause(ASTFactory.NULL p, String constraintType, boolean brief, boolean verbose, Object where, boolean hasYield) {
        throw new UnsupportedOperationException("showConstraintClause is not a literal");
    }

    public ASTFactory.NULL showProcedureClause(ASTFactory.NULL p, boolean currentUser, String user, Object where, boolean hasYield) {
        throw new UnsupportedOperationException("showProcedureClause is not a literal");
    }

    public ASTFactory.NULL showFunctionClause(ASTFactory.NULL p, String functionType, boolean currentUser, String user, Object where, boolean hasYield) {
        throw new UnsupportedOperationException("showFunctionClause is not a literal");
    }

    public ASTFactory.NULL grantRoles(ASTFactory.NULL p, List<Either<String, Object>> roles, List<Either<String, Object>> users) {
        throw new UnsupportedOperationException("grantRoles is not a literal");
    }

    public ASTFactory.NULL revokeRoles(ASTFactory.NULL p, List<Either<String, Object>> roles, List<Either<String, Object>> users) {
        throw new UnsupportedOperationException("revokeRoles is not a literal");
    }

    public ASTFactory.NULL showDatabase(ASTFactory.NULL p, ASTFactory.NULL aNull, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, Object where) {
        throw new UnsupportedOperationException("showDatabase is not a literal");
    }

    public ASTFactory.NULL createDatabase(ASTFactory.NULL p, boolean replace, Either<String, Object> databaseName, boolean ifNotExists, ASTFactory.NULL aNull, Either<Map<String, Object>, Object> options) {
        throw new UnsupportedOperationException("createDatabase is not a literal");
    }

    public ASTFactory.NULL dropDatabase(ASTFactory.NULL p, Either<String, Object> databaseName, boolean ifExists, boolean dumpData, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("dropDatabase is not a literal");
    }

    public ASTFactory.NULL startDatabase(ASTFactory.NULL p, Either<String, Object> databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("startDatabase is not a literal");
    }

    public ASTFactory.NULL stopDatabase(ASTFactory.NULL p, Either<String, Object> databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("stopDatabase is not a literal");
    }

    public ASTFactory.NULL databaseScope(ASTFactory.NULL p, Either<String, Object> name, boolean isDefault, boolean isHome) {
        throw new UnsupportedOperationException("databaseScope is not a literal");
    }

    public ASTFactory.NULL wait(boolean wait, long seconds) {
        throw new UnsupportedOperationException("wait is not a literal");
    }

    public Object newVariable(ASTFactory.NULL p, String name) {
        throw new UnsupportedOperationException("newVariable is not a literal");
    }

    public Object newParameter(ASTFactory.NULL p, Object v, ParameterType type) {
        throw new UnsupportedOperationException("newParameter is not a literal");
    }

    public Object newParameter(ASTFactory.NULL p, String offset, ParameterType type) {
        throw new UnsupportedOperationException("newParameter is not a literal");
    }

    public Object newSensitiveStringParameter(ASTFactory.NULL p, Object v) {
        throw new UnsupportedOperationException("newSensitiveStringParameter is not a literal");
    }

    public Object newSensitiveStringParameter(ASTFactory.NULL p, String offset) {
        throw new UnsupportedOperationException("newSensitiveStringParameter is not a literal");
    }

    public Object oldParameter(ASTFactory.NULL p, Object v) {
        throw new UnsupportedOperationException("oldParameter is not a literal");
    }

    public Object newDouble(ASTFactory.NULL p, String image) {
        return Double.valueOf(image);
    }

    public Object newDecimalInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_DECIMAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    public Object newHexInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image.substring(2), 16);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_HEXADECIMAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    public Object newOctalInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = image.charAt(1) == 'o' ? Long.parseLong(image.substring(2), 8) : Long.parseLong(image, 8);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && (LONG_MIN_VALUE_OCTAL_STRING.equals(image) || LONG_MIN_VALUE_OCTAL_STRING_OLD_SYNTAX.equals(image))) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    public Object newString(ASTFactory.NULL p, String image) {
        return image;
    }

    public Object newTrueLiteral(ASTFactory.NULL p) {
        return Boolean.TRUE;
    }

    public Object newFalseLiteral(ASTFactory.NULL p) {
        return Boolean.FALSE;
    }

    public Object newNullLiteral(ASTFactory.NULL p) {
        return null;
    }

    public Object listLiteral(ASTFactory.NULL p, List<Object> values) {
        return values;
    }

    public Object mapLiteral(ASTFactory.NULL p, List<ASTFactory.StringPos<ASTFactory.NULL>> keys, List<Object> values) {
        HashMap<String, Object> x = new HashMap<String, Object>();
        Iterator<ASTFactory.StringPos<ASTFactory.NULL>> keyIterator = keys.iterator();
        Iterator<Object> valueIterator = values.iterator();
        while (keyIterator.hasNext()) {
            x.put(keyIterator.next().string, valueIterator.next());
        }
        return x;
    }

    public Object hasLabelsOrTypes(Object subject, List<ASTFactory.StringPos<ASTFactory.NULL>> labels) {
        throw new UnsupportedOperationException("hasLabels is not a literal");
    }

    public Object property(Object subject, ASTFactory.StringPos<ASTFactory.NULL> propertyKeyName) {
        throw new UnsupportedOperationException("property is not a literal");
    }

    public Object or(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("or is not a literal");
    }

    public Object xor(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("xor is not a literal");
    }

    public Object and(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("and is not a literal");
    }

    public Object ands(List<Object> exprs) {
        throw new UnsupportedOperationException("ands is not a literal");
    }

    public Object not(Object e) {
        throw new UnsupportedOperationException("not is not a literal");
    }

    public Object plus(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("plus is not a literal");
    }

    public Object minus(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("minus is not a literal");
    }

    public Object multiply(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("multiply is not a literal");
    }

    public Object divide(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("divide is not a literal");
    }

    public Object modulo(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("modulo is not a literal");
    }

    public Object pow(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("pow is not a literal");
    }

    public Object unaryPlus(Object e) {
        throw new UnsupportedOperationException("unaryPlus is not a literal");
    }

    public Object unaryPlus(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("unaryPlus is not a literal");
    }

    public Object unaryMinus(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("unaryMinus is not a literal");
    }

    public Object eq(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("eq is not a literal");
    }

    public Object neq(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("neq is not a literal");
    }

    public Object neq2(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("neq2 is not a literal");
    }

    public Object lte(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("lte is not a literal");
    }

    public Object gte(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("gte is not a literal");
    }

    public Object lt(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("lt is not a literal");
    }

    public Object gt(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("gt is not a literal");
    }

    public Object regeq(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("regeq is not a literal");
    }

    public Object startsWith(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("startsWith is not a literal");
    }

    public Object endsWith(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("endsWith is not a literal");
    }

    public Object contains(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("contains is not a literal");
    }

    public Object in(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("in is not a literal");
    }

    public Object isNull(Object e) {
        throw new UnsupportedOperationException("isNull is not a literal");
    }

    public Object listLookup(Object list, Object index) {
        throw new UnsupportedOperationException("listLookup is not a literal");
    }

    public Object listSlice(ASTFactory.NULL p, Object list, Object start, Object end) {
        throw new UnsupportedOperationException("listSlice is not a literal");
    }

    public Object newCountStar(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("newCountStar is not a literal");
    }

    public Object functionInvocation(ASTFactory.NULL p, List<String> namespace, String name, boolean distinct, List<Object> arguments) {
        if (namespace.isEmpty()) {
            switch (name.toLowerCase(Locale.ROOT)) {
                case "date": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, DateValue::now, DateValue::parse, DateValue::build);
                }
                case "datetime": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, DateTimeValue::now, s -> DateTimeValue.parse((CharSequence)s, () -> DEFAULT_ZONE_ID), DateTimeValue::build);
                }
                case "time": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, TimeValue::now, s -> TimeValue.parse((CharSequence)s, () -> DEFAULT_ZONE_ID), TimeValue::build);
                }
                case "localtime": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, LocalTimeValue::now, LocalTimeValue::parse, LocalTimeValue::build);
                }
                case "localdatetime": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, LocalDateTimeValue::now, LocalDateTimeValue::parse, LocalDateTimeValue::build);
                }
                case "duration": {
                    return LiteralInterpreter.createDurationValue(arguments);
                }
                case "point": {
                    return LiteralInterpreter.createPoint(arguments);
                }
            }
            throw new UnsupportedOperationException("functionInvocation (" + name + ") is not a literal");
        }
        throw new UnsupportedOperationException("functionInvocation is not a literal");
    }

    private static PointValue createPoint(List<Object> arguments) {
        if (arguments.size() == 1) {
            Object point = arguments.get(0);
            if (point == null) {
                return null;
            }
            if (point instanceof Map) {
                Map pointAsMap = (Map)point;
                return PointValue.fromMap((MapValue)LiteralInterpreter.asMapValue(pointAsMap));
            }
            throw new IllegalArgumentException("Function `point` did not get expected argument. Expected a string or map input but got " + point.getClass().getSimpleName() + ".");
        }
        throw new IllegalArgumentException("Function `point` did not get expected number of arguments: expected 1 argument, got " + arguments.size() + " arguments.");
    }

    private static <T> T createTemporalValue(List<Object> arguments, String functionName, Function<Clock, T> onEmpty, Function<String, T> onString, BiFunction<MapValue, Supplier<ZoneId>, T> onMap) {
        if (arguments.isEmpty()) {
            return onEmpty.apply(Clock.system(DEFAULT_ZONE_ID));
        }
        if (arguments.size() == 1) {
            Object date = arguments.get(0);
            if (date == null) {
                return null;
            }
            if (date instanceof String) {
                return onString.apply((String)date);
            }
            if (date instanceof Map) {
                MapValue dateMap = LiteralInterpreter.asMapValue((Map)date);
                return onMap.apply(dateMap, () -> DEFAULT_ZONE_ID);
            }
        }
        throw new IllegalArgumentException("Function `" + functionName + "` did not get expected number of arguments: expected 0 or 1 argument, got " + arguments.size() + " arguments.");
    }

    private static DurationValue createDurationValue(List<Object> arguments) {
        if (arguments.size() == 1) {
            Object duration = arguments.get(0);
            if (duration instanceof String) {
                return DurationValue.parse((CharSequence)((String)duration));
            }
            if (duration instanceof Map) {
                MapValue dateMap = LiteralInterpreter.asMapValue((Map)duration);
                return DurationValue.build((MapValue)dateMap);
            }
        }
        throw new IllegalArgumentException("Function `duration` did not get expected number of arguments: expected 1 argument, got " + arguments.size() + " arguments.");
    }

    public Object listComprehension(ASTFactory.NULL p, Object v, Object list, Object where, Object projection) {
        throw new UnsupportedOperationException("listComprehension is not a literal");
    }

    public Object patternComprehension(ASTFactory.NULL p, Object v, ASTFactory.NULL aNull, Object where, Object projection) {
        throw new UnsupportedOperationException("patternComprehension is not a literal");
    }

    public Object filterExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("filterExpression is not a literal");
    }

    public Object extractExpression(ASTFactory.NULL p, Object v, Object list, Object where, Object projection) {
        throw new UnsupportedOperationException("extractExpression is not a literal");
    }

    public Object reduceExpression(ASTFactory.NULL p, Object acc, Object accExpr, Object v, Object list, Object innerExpr) {
        throw new UnsupportedOperationException("reduceExpression is not a literal");
    }

    public Object allExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("allExpression is not a literal");
    }

    public Object anyExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("anyExpression is not a literal");
    }

    public Object noneExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("noneExpression is not a literal");
    }

    public Object singleExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("singleExpression is not a literal");
    }

    public Object patternExpression(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("patternExpression is not a literal");
    }

    public Object existsSubQuery(ASTFactory.NULL p, List<ASTFactory.NULL> nulls, Object where) {
        throw new UnsupportedOperationException("existsSubQuery is not a literal");
    }

    public Object mapProjection(ASTFactory.NULL p, Object v, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("mapProjection is not a literal");
    }

    public ASTFactory.NULL mapProjectionLiteralEntry(ASTFactory.StringPos<ASTFactory.NULL> property, Object value) {
        throw new UnsupportedOperationException("mapProjectionLiteralEntry is not a literal");
    }

    public ASTFactory.NULL mapProjectionProperty(ASTFactory.StringPos<ASTFactory.NULL> property) {
        throw new UnsupportedOperationException("mapProjectionProperty is not a literal");
    }

    public ASTFactory.NULL mapProjectionVariable(Object v) {
        throw new UnsupportedOperationException("mapProjectionVariable is not a literal");
    }

    public ASTFactory.NULL mapProjectionAll(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("mapProjectionAll is not a literal");
    }

    public Object caseExpression(ASTFactory.NULL p, Object e, List<Object> whens, List<Object> thens, Object elze) {
        throw new UnsupportedOperationException("caseExpression is not a literal");
    }

    public ASTFactory.NULL inputPosition(int offset, int line, int column) {
        return null;
    }

    private static MapValue asMapValue(Map<String, ?> map) {
        int size = map.size();
        if (size == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(size);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            builder.add(entry.getKey(), (AnyValue)Values.of(entry.getValue()));
        }
        return builder.build();
    }
}

