/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;

public class LiteralInterpreter
implements ASTFactory<ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, Object, Object, Object, ASTFactory.NULL, ASTFactory.NULL> {
    public static final String LONG_MIN_VALUE_DECIMAL_STRING = Long.toString(Long.MIN_VALUE).substring(1);
    public static final String LONG_MIN_VALUE_HEXADECIMAL_STRING = "0x" + Long.toString(Long.MIN_VALUE, 16).substring(1);
    public static final String LONG_MIN_VALUE_OCTAL_STRING = "0" + Long.toString(Long.MIN_VALUE, 8).substring(1);

    @Override
    public ASTFactory.NULL newSingleQuery(List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("newSingleQuery is not a literal");
    }

    @Override
    public ASTFactory.NULL newUnion(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean all) {
        throw new UnsupportedOperationException("newUnion is not a literal");
    }

    @Override
    public ASTFactory.NULL periodicCommitQuery(ASTFactory.NULL p, String batchSize, ASTFactory.NULL loadCsv, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("periodicCommitQuery is not a literal");
    }

    @Override
    public ASTFactory.NULL newReturnClause(ASTFactory.NULL p, boolean distinct, boolean returnAll, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> order, Object skip, Object limit) {
        throw new UnsupportedOperationException("newReturnClause is not a literal");
    }

    @Override
    public ASTFactory.NULL newReturnItem(ASTFactory.NULL p, Object e, Object v) {
        throw new UnsupportedOperationException("newReturnItem is not a literal");
    }

    @Override
    public ASTFactory.NULL newReturnItem(ASTFactory.NULL p, Object e, int eStartLine, int eStartColumn, int eEndLine, int eEndColumn) {
        throw new UnsupportedOperationException("newReturnItem is not a literal");
    }

    @Override
    public ASTFactory.NULL orderDesc(Object e) {
        throw new UnsupportedOperationException("orderDesc is not a literal");
    }

    @Override
    public ASTFactory.NULL orderAsc(Object e) {
        throw new UnsupportedOperationException("orderAsc is not a literal");
    }

    @Override
    public ASTFactory.NULL withClause(ASTFactory.NULL p, ASTFactory.NULL aNull, Object where) {
        throw new UnsupportedOperationException("withClause is not a literal");
    }

    @Override
    public ASTFactory.NULL matchClause(ASTFactory.NULL p, boolean optional, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> nulls2, Object where) {
        throw new UnsupportedOperationException("matchClause is not a literal");
    }

    @Override
    public ASTFactory.NULL usingIndexHint(ASTFactory.NULL p, Object v, String label, List<String> properties, boolean seekOnly) {
        throw new UnsupportedOperationException("usingIndexHint is not a literal");
    }

    @Override
    public ASTFactory.NULL usingJoin(ASTFactory.NULL p, List<Object> joinVariables) {
        throw new UnsupportedOperationException("usingJoin is not a literal");
    }

    @Override
    public ASTFactory.NULL usingScan(ASTFactory.NULL p, Object v, String label) {
        throw new UnsupportedOperationException("usingScan is not a literal");
    }

    @Override
    public ASTFactory.NULL createClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("createClause is not a literal");
    }

    @Override
    public ASTFactory.NULL setClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("setClause is not a literal");
    }

    @Override
    public ASTFactory.NULL setProperty(Object o, Object value) {
        throw new UnsupportedOperationException("setProperty is not a literal");
    }

    @Override
    public ASTFactory.NULL setVariable(Object o, Object value) {
        throw new UnsupportedOperationException("setVariable is not a literal");
    }

    @Override
    public ASTFactory.NULL addAndSetVariable(Object o, Object value) {
        throw new UnsupportedOperationException("addAndSetVariable is not a literal");
    }

    @Override
    public ASTFactory.NULL setLabels(Object o, List<String> value) {
        throw new UnsupportedOperationException("setLabels is not a literal");
    }

    @Override
    public ASTFactory.NULL removeClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("removeClause is not a literal");
    }

    @Override
    public ASTFactory.NULL removeProperty(Object o) {
        throw new UnsupportedOperationException("removeProperty is not a literal");
    }

    @Override
    public ASTFactory.NULL removeLabels(Object o, List<String> labels) {
        throw new UnsupportedOperationException("removeLabels is not a literal");
    }

    @Override
    public ASTFactory.NULL deleteClause(ASTFactory.NULL p, boolean detach, List<Object> objects) {
        throw new UnsupportedOperationException("deleteClause is not a literal");
    }

    @Override
    public ASTFactory.NULL unwindClause(ASTFactory.NULL p, Object e, Object v) {
        throw new UnsupportedOperationException("unwindClause is not a literal");
    }

    @Override
    public ASTFactory.NULL mergeClause(ASTFactory.NULL p, ASTFactory.NULL aNull, List<ASTFactory.NULL> onMatch, List<ASTFactory.NULL> onCreate) {
        throw new UnsupportedOperationException("mergeClause is not a literal");
    }

    @Override
    public ASTFactory.NULL callClause(ASTFactory.NULL p, List<String> namespace, String name, List<Object> arguments, List<ASTFactory.NULL> nulls, Object where) {
        throw new UnsupportedOperationException("callClause is not a literal");
    }

    @Override
    public ASTFactory.NULL callResultItem(String name, Object v) {
        throw new UnsupportedOperationException("callResultItem is not a literal");
    }

    @Override
    public ASTFactory.NULL namedPattern(Object v, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("namedPattern is not a literal");
    }

    @Override
    public ASTFactory.NULL shortestPathPattern(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("shortestPathPattern is not a literal");
    }

    @Override
    public ASTFactory.NULL allShortestPathsPattern(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("allShortestPathsPattern is not a literal");
    }

    @Override
    public ASTFactory.NULL everyPathPattern(List<ASTFactory.NULL> nodes, List<ASTFactory.NULL> relationships) {
        throw new UnsupportedOperationException("everyPathPattern is not a literal");
    }

    @Override
    public ASTFactory.NULL nodePattern(ASTFactory.NULL p, Object v, List<String> labels, Object properties) {
        throw new UnsupportedOperationException("nodePattern is not a literal");
    }

    @Override
    public ASTFactory.NULL relationshipPattern(ASTFactory.NULL p, boolean left, boolean right, Object v, List<String> relTypes, ASTFactory.NULL aNull, Object properties) {
        throw new UnsupportedOperationException("relationshipPattern is not a literal");
    }

    @Override
    public ASTFactory.NULL pathLength(ASTFactory.NULL p, String minLength, String maxLength) {
        throw new UnsupportedOperationException("pathLength is not a literal");
    }

    @Override
    public ASTFactory.NULL loadCsvClause(ASTFactory.NULL p, boolean headers, Object source, Object v, String fieldTerminator) {
        throw new UnsupportedOperationException("loadCsvClause is not a literal");
    }

    @Override
    public ASTFactory.NULL foreachClause(ASTFactory.NULL p, Object v, Object list, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("foreachClause is not a literal");
    }

    @Override
    public ASTFactory.NULL subqueryClause(ASTFactory.NULL p, ASTFactory.NULL subquery) {
        throw new UnsupportedOperationException("subqueryClause is not a literal");
    }

    @Override
    public Object newVariable(ASTFactory.NULL p, String name) {
        throw new UnsupportedOperationException("newVariable is not a literal");
    }

    @Override
    public Object newParameter(ASTFactory.NULL p, Object v) {
        throw new UnsupportedOperationException("newParameter is not a literal");
    }

    @Override
    public Object newParameter(ASTFactory.NULL p, String offset) {
        throw new UnsupportedOperationException("newParameter is not a literal");
    }

    @Override
    public Object newDouble(ASTFactory.NULL p, String image) {
        return Double.valueOf(image);
    }

    @Override
    public Object newDecimalInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_DECIMAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    @Override
    public Object newHexInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image.substring(2), 16);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_HEXADECIMAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    @Override
    public Object newOctalInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image, 8);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_OCTAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    @Override
    public Object newString(ASTFactory.NULL p, String image) {
        return image;
    }

    @Override
    public Object newTrueLiteral(ASTFactory.NULL p) {
        return Boolean.TRUE;
    }

    @Override
    public Object newFalseLiteral(ASTFactory.NULL p) {
        return Boolean.FALSE;
    }

    @Override
    public Object newNullLiteral(ASTFactory.NULL p) {
        return null;
    }

    @Override
    public Object listLiteral(ASTFactory.NULL p, List<Object> values) {
        return values;
    }

    @Override
    public Object mapLiteral(ASTFactory.NULL p, List<String> keys, List<Object> values) {
        HashMap<String, Object> x = new HashMap<String, Object>();
        Iterator<String> keyIterator = keys.iterator();
        Iterator<Object> valueIterator = values.iterator();
        while (keyIterator.hasNext()) {
            x.put(keyIterator.next(), valueIterator.next());
        }
        return x;
    }

    @Override
    public Object hasLabels(Object subject, List<String> labels) {
        throw new UnsupportedOperationException("hasLabels is not a literal");
    }

    @Override
    public Object property(Object subject, String propertyKeyName) {
        throw new UnsupportedOperationException("property is not a literal");
    }

    @Override
    public Object or(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("or is not a literal");
    }

    @Override
    public Object xor(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("xor is not a literal");
    }

    @Override
    public Object and(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("and is not a literal");
    }

    @Override
    public Object ands(List<Object> exprs) {
        throw new UnsupportedOperationException("ands is not a literal");
    }

    @Override
    public Object not(Object e) {
        throw new UnsupportedOperationException("not is not a literal");
    }

    @Override
    public Object plus(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("plus is not a literal");
    }

    @Override
    public Object minus(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("minus is not a literal");
    }

    @Override
    public Object multiply(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("multiply is not a literal");
    }

    @Override
    public Object divide(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("divide is not a literal");
    }

    @Override
    public Object modulo(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("modulo is not a literal");
    }

    @Override
    public Object pow(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("pow is not a literal");
    }

    @Override
    public Object unaryPlus(Object e) {
        throw new UnsupportedOperationException("unaryPlus is not a literal");
    }

    @Override
    public Object unaryMinus(Object e) {
        throw new UnsupportedOperationException("unaryMinus is not a literal");
    }

    @Override
    public Object eq(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("eq is not a literal");
    }

    @Override
    public Object neq(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("neq is not a literal");
    }

    @Override
    public Object neq2(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("neq2 is not a literal");
    }

    @Override
    public Object lte(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("lte is not a literal");
    }

    @Override
    public Object gte(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("gte is not a literal");
    }

    @Override
    public Object lt(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("lt is not a literal");
    }

    @Override
    public Object gt(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("gt is not a literal");
    }

    @Override
    public Object regeq(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("regeq is not a literal");
    }

    @Override
    public Object startsWith(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("startsWith is not a literal");
    }

    @Override
    public Object endsWith(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("endsWith is not a literal");
    }

    @Override
    public Object contains(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("contains is not a literal");
    }

    @Override
    public Object in(Object lhs, Object rhs) {
        throw new UnsupportedOperationException("in is not a literal");
    }

    @Override
    public Object isNull(Object e) {
        throw new UnsupportedOperationException("isNull is not a literal");
    }

    @Override
    public Object listLookup(Object list, Object index) {
        throw new UnsupportedOperationException("listLookup is not a literal");
    }

    @Override
    public Object listSlice(ASTFactory.NULL p, Object list, Object start, Object end) {
        throw new UnsupportedOperationException("listSlice is not a literal");
    }

    @Override
    public Object newCountStar(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("newCountStar is not a literal");
    }

    @Override
    public Object functionInvocation(ASTFactory.NULL p, List<String> namespace, String name, boolean distinct, List<Object> arguments) {
        throw new UnsupportedOperationException("functionInvocation is not a literal");
    }

    @Override
    public Object listComprehension(ASTFactory.NULL p, Object v, Object list, Object where, Object projection) {
        throw new UnsupportedOperationException("listComprehension is not a literal");
    }

    @Override
    public Object patternComprehension(ASTFactory.NULL p, Object v, ASTFactory.NULL aNull, Object where, Object projection) {
        throw new UnsupportedOperationException("patternComprehension is not a literal");
    }

    @Override
    public Object filterExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("filterExpression is not a literal");
    }

    @Override
    public Object extractExpression(ASTFactory.NULL p, Object v, Object list, Object where, Object projection) {
        throw new UnsupportedOperationException("extractExpression is not a literal");
    }

    @Override
    public Object reduceExpression(ASTFactory.NULL p, Object acc, Object accExpr, Object v, Object list, Object innerExpr) {
        throw new UnsupportedOperationException("reduceExpression is not a literal");
    }

    @Override
    public Object allExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("allExpression is not a literal");
    }

    @Override
    public Object anyExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("anyExpression is not a literal");
    }

    @Override
    public Object noneExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("noneExpression is not a literal");
    }

    @Override
    public Object singleExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("singleExpression is not a literal");
    }

    @Override
    public Object patternExpression(ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("patternExpression is not a literal");
    }

    @Override
    public Object existsSubQuery(ASTFactory.NULL p, List<ASTFactory.NULL> nulls, Object where) {
        throw new UnsupportedOperationException("existsSubQuery is not a literal");
    }

    @Override
    public Object mapProjection(ASTFactory.NULL p, Object v, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("mapProjection is not a literal");
    }

    @Override
    public ASTFactory.NULL mapProjectionLiteralEntry(String property, Object value) {
        throw new UnsupportedOperationException("mapProjectionLiteralEntry is not a literal");
    }

    @Override
    public ASTFactory.NULL mapProjectionProperty(String property) {
        throw new UnsupportedOperationException("mapProjectionProperty is not a literal");
    }

    @Override
    public ASTFactory.NULL mapProjectionVariable(Object v) {
        throw new UnsupportedOperationException("mapProjectionVariable is not a literal");
    }

    @Override
    public ASTFactory.NULL mapProjectionAll(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("mapProjectionAll is not a literal");
    }

    @Override
    public Object caseExpression(ASTFactory.NULL p, Object e, List<Object> whens, List<Object> thens, Object elze) {
        throw new UnsupportedOperationException("caseExpression is not a literal");
    }

    @Override
    public ASTFactory.NULL inputPosition(int offset, int line, int column) {
        return null;
    }
}

