/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.ast.util;

import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.ast.IfExistsDo;
import org.neo4j.cypher.internal.ast.IfExistsDoNothing$;
import org.neo4j.cypher.internal.ast.IfExistsInvalidSyntax$;
import org.neo4j.cypher.internal.ast.IfExistsReplace$;
import org.neo4j.cypher.internal.ast.IfExistsThrowError$;
import org.neo4j.cypher.internal.expressions.PathLengthQuantifier;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.lexer.CypherQueryAccess;
import org.neo4j.cypher.internal.parser.lexer.CypherToken;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.collection.immutable.ListSet;
import org.neo4j.cypher.internal.util.collection.immutable.ListSet$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.ScalaRunTime$;

public final class Util$ {
    public static final Util$ MODULE$ = new Util$();

    public <T> T cast(Object o) {
        return (T)o;
    }

    public <T extends ParseTree> T child(AstRuleCtx ctx, int index) {
        return (T)ctx.getChild(index);
    }

    public <T> Option<T> astOpt(AstRuleCtx ctx) {
        if (ctx == null) {
            return None$.MODULE$;
        }
        return new Some(ctx.ast());
    }

    public <T> T astOpt(AstRuleCtx ctx, Function0<T> function0) {
        if (ctx == null) {
            return (T)function0.apply();
        }
        return (T)ctx.ast();
    }

    public <T> Option<T> astOptFromList(List<? extends AstRuleCtx> list, Function0<Option<T>> function0) {
        int size = list.size();
        if (size == 0) {
            return (Option)function0.apply();
        }
        if (size == 1) {
            return new Some(list.get(0).ast());
        }
        throw new IllegalArgumentException("Unexpected size " + size);
    }

    public Option<PathLengthQuantifier> optSafeUnsignedDecimalInt(Token token) {
        if (token != null) {
            return new Some((Object)this.safeUnsignedDecimalInt(token));
        }
        return None$.MODULE$;
    }

    public PathLengthQuantifier safeUnsignedDecimalInt(Token token) {
        return new PathLengthQuantifier(token.getText(), this.pos(token));
    }

    public AstRuleCtx ctxChild(AstRuleCtx ctx, int index) {
        return (AstRuleCtx)ctx.getChild(index);
    }

    public <T> T astChild(AstRuleCtx ctx, int index) {
        return (T)((AstRuleCtx)ctx.getChild(index)).ast();
    }

    public <T> ArraySeq<T> astSeq(List<? extends ParseTree> list, int from, ClassTag<T> evidence$1) {
        int size = list.size();
        Object result = evidence$1.newArray(size - from);
        int i = from;
        int dest = 0;
        while (i < size) {
            ScalaRunTime$.MODULE$.array_update(result, dest, ((AstRuleCtx)list.get(i)).ast());
            ++i;
            ++dest;
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(result);
    }

    public <T> ArraySeq<T> astSeq(List<? extends ParseTree> list, int offset, int step, ClassTag<T> evidence$2) {
        int size = list.size();
        Object result = evidence$2.newArray(size / step);
        int i = offset;
        int dest = 0;
        while (i < size) {
            ScalaRunTime$.MODULE$.array_update(result, dest, ((AstRuleCtx)list.get(i)).ast());
            i += step;
            ++dest;
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(result);
    }

    public <T> int astSeq$default$2() {
        return 0;
    }

    public <T, C> ArraySeq<T> astSeqPositioned(List<? extends ParseTree> list, Function1<C, Function1<InputPosition, T>> func, ClassTag<T> evidence$3) {
        int size = list.size();
        Object result = evidence$3.newArray(size);
        for (int i = 0; i < size; ++i) {
            AstRuleCtx item = (AstRuleCtx)list.get(i);
            ScalaRunTime$.MODULE$.array_update(result, i, ((Function1)func.apply(item.ast())).apply((Object)this.pos((ParserRuleContext)item)));
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(result);
    }

    public <T extends ASTNode> ListSet<T> astChildListSet(AstRuleCtx ctx) {
        return ListSet$.MODULE$.from(this.collectAst(ctx));
    }

    public <T extends ASTNode, C extends AstRuleCtx> T astCtxReduce(AstRuleCtx ctx, Function2<T, C, T> f) {
        List children = ctx.children;
        int size = children.size();
        ASTNode result = (ASTNode)((AstRuleCtx)children.get(0)).ast();
        for (int i = 1; i < size; ++i) {
            result = (ASTNode)f.apply((Object)result, (Object)((AstRuleCtx)children.get(i)));
        }
        return (T)result;
    }

    public <T extends ASTNode> T astBinaryFold(AstRuleCtx ctx, Function3<T, TerminalNode, T, T> f) {
        int n = ctx.children.size();
        switch (n) {
            case 1: {
                return (T)((ASTNode)this.ctxChild(ctx, 0).ast());
            }
        }
        ASTNode z = (ASTNode)f.apply(this.ctxChild(ctx, 0).ast(), this.child(ctx, 1), this.ctxChild(ctx, 2).ast());
        if (n == 3) {
            return (T)z;
        }
        return (T)((ASTNode)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)ctx.children).asScala().drop(3)).toSeq().grouped(2).foldLeft((Object)z, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                SeqOps seqOps;
                ASTNode acc = (ASTNode)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    ParseTree token = (ParseTree)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    ParseTree rhs = (ParseTree)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (token instanceof TerminalNode) {
                        TerminalNode terminalNode = (TerminalNode)token;
                        if (rhs instanceof AstRuleCtx) {
                            AstRuleCtx astRuleCtx = (AstRuleCtx)rhs;
                            return (ASTNode)f.apply((Object)acc, (Object)terminalNode, astRuleCtx.ast());
                        }
                    }
                }
            }
            throw new IllegalStateException("Unexpected parse result " + ctx);
        }));
    }

    private <T extends ASTNode> Iterable<T> collectAst(AstRuleCtx ctx) {
        return (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)ctx.children).asScala().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends ParseTree, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AstRuleCtx) {
                    AstRuleCtx astRuleCtx = (AstRuleCtx)A1;
                    return (B1)astRuleCtx.ast();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ParseTree x1) {
                ParseTree parseTree = x1;
                return parseTree instanceof AstRuleCtx;
            }
        });
    }

    public TerminalNode nodeChild(AstRuleCtx ctx, int index) {
        return (TerminalNode)ctx.getChild(index);
    }

    public int nodeChildType(AstRuleCtx ctx, int index) {
        return ((TerminalNode)ctx.getChild(index)).getSymbol().getType();
    }

    public <T> T lastChild(AstRuleCtx ctx) {
        return (T)ctx.children.get(ctx.children.size() - 1);
    }

    public <A extends ASTNode, B extends ASTNode> ArraySeq<Tuple2<A, B>> astPairs(List<? extends AstRuleCtx> as, List<? extends AstRuleCtx> bs) {
        Tuple2[] result = new Tuple2[as.size()];
        int length = as.size();
        for (int i = 0; i < length; ++i) {
            result[i] = new Tuple2(as.get(i).ast(), bs.get(i).ast());
        }
        return ArraySeq$.MODULE$.unsafeWrapArray((Object)result);
    }

    public InputPosition pos(Token token) {
        return ((CypherToken)token).position();
    }

    public InputPosition pos(ParserRuleContext ctx) {
        return this.pos(ctx.start);
    }

    public InputPosition pos(TerminalNode node) {
        return this.pos(node.getSymbol());
    }

    public String inputText(AstRuleCtx ctx) {
        return ((CypherQueryAccess)ctx.stop.getTokenSource()).inputText(ctx.start, ctx.stop);
    }

    public InputPosition.Range rangePos(ParserRuleContext ctx) {
        InputPosition start = this.pos(ctx);
        CypherToken stopToken = (CypherToken)ctx.stop;
        return start.withInputLength(stopToken.inputOffset(stopToken.getStopIndex()) - start.offset() + 1);
    }

    public IfExistsDo ifExistsDo(boolean replace, boolean ifNotExists) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(replace, ifNotExists);
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return IfExistsInvalidSyntax$.MODULE$;
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return IfExistsReplace$.MODULE$;
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (!bl && bl4) {
                return IfExistsDoNothing$.MODULE$;
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (!bl && !bl5) {
                return IfExistsThrowError$.MODULE$;
            }
        }
        throw new MatchError((Object)sp2);
    }

    public SemanticDirection semanticDirection(boolean hasRightArrow, boolean hasLeftArrow) {
        if (hasRightArrow && !hasLeftArrow) {
            return SemanticDirection.OUTGOING$.MODULE$;
        }
        if (hasLeftArrow && !hasRightArrow) {
            return SemanticDirection.INCOMING$.MODULE$;
        }
        return SemanticDirection.BOTH$.MODULE$;
    }

    private Util$() {
    }
}

