/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.Locker;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.time.SystemNanoClock;

public class TestDatabaseManagementServiceFactory
extends DatabaseManagementServiceFactory {
    private final FileSystemAbstraction fileSystem;
    private InternalLogProvider internalLogProvider;
    private final SystemNanoClock clock;

    public TestDatabaseManagementServiceFactory(DbmsInfo dbmsInfo, Function<GlobalModule, AbstractEditionModule> editionFactory, FileSystemAbstraction fileSystem, SystemNanoClock clock, InternalLogProvider internalLogProvider) {
        super(dbmsInfo, editionFactory);
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.clock = clock;
        this.internalLogProvider = internalLogProvider;
    }

    protected GlobalModule createGlobalModule(Config config, boolean daemonMode, ExternalDependencies dependencies) {
        config.setIfNotSet(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ZERO);
        if (!this.fileSystem.isPersistent()) {
            config.setIfNotSet(GraphDatabaseSettings.keep_logical_logs, (Object)"1 files");
        }
        return new TestDatabaseGlobalModule(config, daemonMode, this.dbmsInfo, dependencies);
    }

    public class TestDatabaseGlobalModule
    extends GlobalModule {
        public TestDatabaseGlobalModule(Config config, boolean daemonMode, DbmsInfo dbmsInfo, ExternalDependencies dependencies) {
            super(config, dbmsInfo, daemonMode, dependencies);
        }

        protected FileSystemAbstraction createFileSystemAbstraction() {
            return TestDatabaseManagementServiceFactory.this.fileSystem;
        }

        protected LogService createLogService(InternalLogProvider userLogProvider, boolean daemonMode) {
            if (TestDatabaseManagementServiceFactory.this.internalLogProvider == null) {
                if (TestDatabaseManagementServiceFactory.this.fileSystem.isPersistent()) {
                    return super.createLogService(userLogProvider, daemonMode);
                }
                if (((Boolean)this.getGlobalConfig().get(GraphDatabaseSettings.debug_log_enabled)).booleanValue()) {
                    try {
                        return this.specialLoggingForEphemeral(userLogProvider);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to set up logging for EphemeralFilesystem", e);
                    }
                }
                TestDatabaseManagementServiceFactory.this.internalLogProvider = NullLogProvider.getInstance();
            }
            return new SimpleLogService(userLogProvider, TestDatabaseManagementServiceFactory.this.internalLogProvider, true);
        }

        private SimpleLogService specialLoggingForEphemeral(InternalLogProvider userLogProvider) throws IOException {
            Config config = this.getGlobalConfig();
            Path logDir = (Path)config.get(GraphDatabaseSettings.logs_directory);
            TestDatabaseManagementServiceFactory.this.fileSystem.mkdirs(logDir);
            TestDatabaseManagementServiceFactory.this.internalLogProvider = new Log4jLogProvider(TestDatabaseManagementServiceFactory.this.fileSystem.openAsOutputStream(logDir.resolve("debug.log"), true));
            return (SimpleLogService)this.getGlobalLife().add((Lifecycle)new SimpleLogService((InternalLogProvider)(userLogProvider == null ? NullLogProvider.getInstance() : userLogProvider), TestDatabaseManagementServiceFactory.this.internalLogProvider, ((Boolean)config.get(GraphDatabaseInternalSettings.duplication_user_messages)).booleanValue()));
        }

        protected SystemNanoClock createClock() {
            return TestDatabaseManagementServiceFactory.this.clock != null ? TestDatabaseManagementServiceFactory.this.clock : super.createClock();
        }

        protected FileLockerService createFileLockerService() {
            if (TestDatabaseManagementServiceFactory.this.fileSystem.isPersistent()) {
                return super.createFileLockerService();
            }
            return new ImpermanentLockerService();
        }
    }

    private static class ImpermanentLockerService
    implements FileLockerService {
        private ImpermanentLockerService() {
        }

        public Locker createStoreLocker(FileSystemAbstraction fileSystem, Neo4jLayout storeLayout) {
            return new Locker(fileSystem, storeLayout.storeLockFile());
        }

        public Locker createDatabaseLocker(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
            return new Locker(fileSystem, databaseLayout.databaseLockFile());
        }
    }
}

