/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.List;
import org.neo4j.dbms.api.DatabaseAliasExistsException;
import org.neo4j.dbms.api.DatabaseExistsException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.TransactionEventListener;

public class DelegatingDatabaseManagementService
implements DatabaseManagementService {
    final DatabaseManagementService delegate;

    public DelegatingDatabaseManagementService(DatabaseManagementService delegate) {
        this.delegate = delegate;
    }

    public GraphDatabaseService database(String databaseName) throws DatabaseNotFoundException {
        return this.delegate.database(databaseName);
    }

    public void createDatabase(String databaseName, Configuration databaseSpecificSettings) throws DatabaseExistsException {
        this.delegate.createDatabase(databaseName, databaseSpecificSettings);
    }

    public void dropDatabase(String databaseName) throws DatabaseNotFoundException, DatabaseAliasExistsException {
        this.delegate.dropDatabase(databaseName);
    }

    public void startDatabase(String databaseName) throws DatabaseNotFoundException {
        this.delegate.startDatabase(databaseName);
    }

    public void shutdownDatabase(String databaseName) throws DatabaseNotFoundException {
        this.delegate.shutdownDatabase(databaseName);
    }

    public List<String> listDatabases() {
        return this.delegate.listDatabases();
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        this.delegate.registerDatabaseEventListener(listener);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        this.delegate.unregisterDatabaseEventListener(listener);
    }

    public void registerTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        this.delegate.registerTransactionEventListener(databaseName, listener);
    }

    public void unregisterTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        this.delegate.unregisterTransactionEventListener(databaseName, listener);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public static class AutoCloseable
    extends DelegatingDatabaseManagementService
    implements java.lang.AutoCloseable {
        public AutoCloseable(DatabaseManagementService delegate) {
            super(delegate);
        }

        @Override
        public void close() {
            this.shutdown();
        }
    }
}

