/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DbStatistics;
import org.neo4j.test.Unzip;

public interface ZippedStore {
    public DbStatistics statistics();

    public String name();

    public String zipFileName();

    default public void copyZipTo(FileSystemAbstraction fs, Path target) throws IOException {
        URL url = Objects.requireNonNull(this.getClass().getResource(this.zipFileName()));
        try (InputStream inputStream = url.openStream();
             OutputStream outputStream = fs.openAsOutputStream(target, false);){
            inputStream.transferTo(outputStream);
        }
    }

    default public void unzip(Path targetDirectory) throws IOException {
        Unzip.unzip(this.getClass(), (String)this.zipFileName(), (Path)targetDirectory);
    }

    default public Path resolveDbPath(Path targetDirectory) {
        return targetDirectory.resolve("data/databases/neo4j");
    }

    default public Path resolveTxPath(Path targetDirectory) {
        return targetDirectory.resolve("data/transactions/neo4j");
    }
}

