/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.function.Function;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.AdminTool;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileSystemAbstraction;
import picocli.CommandLine;

public class CommandTestUtils {
    public static void withSuppressedOutput(Path homeDir, Path confDir, FileSystemAbstraction fs, ThrowingConsumer<CapturingExecutionContext, Throwable> command) {
        CapturingExecutionContext executionContext = CommandTestUtils.capturingExecutionContext(homeDir, confDir, fs);
        try {
            command.accept((Object)executionContext);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("%nCaptured System.out:%n%s%nCaptured System.err:%n%s", executionContext.outAsString(), executionContext.errAsString()), e);
        }
    }

    public static void runCommandWithSuppressedOutput(Path homeDir, Path confDir, FileSystemAbstraction fs, Function<ExecutionContext, AbstractCommand> command, String ... args) {
        CommandTestUtils.withSuppressedOutput(homeDir, confDir, fs, (ThrowingConsumer<CapturingExecutionContext, Throwable>)((ThrowingConsumer)ctx -> {
            AbstractCommand cmd = (AbstractCommand)command.apply((ExecutionContext)ctx);
            CommandLine.populateCommand((Object)cmd, (String[])args);
            cmd.execute();
        }));
    }

    public static void runAdminToolWithSuppressedOutput(Path homeDir, Path confDir, FileSystemAbstraction fs, String ... args) {
        CommandTestUtils.withSuppressedOutput(homeDir, confDir, fs, (ThrowingConsumer<CapturingExecutionContext, Throwable>)((ThrowingConsumer)ctx -> AdminTool.execute((ExecutionContext)ctx, (String[])args)));
    }

    public static CapturingExecutionContext capturingExecutionContext(Path homeDir, Path confDir, FileSystemAbstraction fs) {
        ByteArrayOutputStream rawOut = new ByteArrayOutputStream();
        ByteArrayOutputStream rawErr = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(rawOut);
        PrintStream err = new PrintStream(rawErr);
        return new CapturingExecutionContext(homeDir, confDir, rawOut, rawErr, out, err, fs);
    }

    public static class CapturingExecutionContext
    extends ExecutionContext {
        private final ByteArrayOutputStream rawOut;
        private final ByteArrayOutputStream rawErr;

        CapturingExecutionContext(Path homePath, Path confPath, ByteArrayOutputStream rawOut, ByteArrayOutputStream rawErr, PrintStream out, PrintStream err, FileSystemAbstraction fs) {
            super(homePath, confPath, out, err, fs);
            this.rawOut = rawOut;
            this.rawErr = rawErr;
        }

        public String outAsString() {
            this.out().flush();
            return this.rawOut.toString();
        }

        public String errAsString() {
            this.err().flush();
            return this.rawErr.toString();
        }
    }
}

