/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class DbRepresentation {
    private final Map<Long, NodeRep> nodes = new TreeMap<Long, NodeRep>();
    private final Set<IndexDefinition> schemaIndexes = new HashSet<IndexDefinition>();
    private final Set<ConstraintDefinition> constraints = new HashSet<ConstraintDefinition>();
    private long highestNodeId;
    private long highestRelationshipId;

    public static DbRepresentation of(GraphDatabaseService db) {
        int retryCount = 30;
        while (true) {
            DbRepresentation dbRepresentation;
            block22: {
                Transaction transaction = db.beginTx();
                try {
                    Schema schema = transaction.schema();
                    schema.awaitIndexesOnline(1L, TimeUnit.MINUTES);
                    DbRepresentation result = new DbRepresentation();
                    try (ResourceIterable allNodes = transaction.getAllNodes();){
                        for (Node node : allNodes) {
                            NodeRep nodeRep = new NodeRep(node);
                            result.nodes.put(node.getId(), nodeRep);
                            result.highestNodeId = Math.max(node.getId(), result.highestNodeId);
                            result.highestRelationshipId = Math.max(nodeRep.highestRelationshipId, result.highestRelationshipId);
                        }
                    }
                    for (IndexDefinition indexDefinition : schema.getIndexes()) {
                        result.schemaIndexes.add(indexDefinition);
                    }
                    for (ConstraintDefinition constraintDefinition : schema.getConstraints()) {
                        result.constraints.add(constraintDefinition);
                    }
                    dbRepresentation = result;
                    if (transaction == null) break block22;
                }
                catch (Throwable schema) {
                    try {
                        if (transaction != null) {
                            try {
                                transaction.close();
                            }
                            catch (Throwable throwable) {
                                schema.addSuppressed(throwable);
                            }
                        }
                        throw schema;
                    }
                    catch (DatabaseShutdownException | TransactionFailureException e) {
                        if (retryCount-- < 0) {
                            throw e;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                transaction.close();
            }
            return dbRepresentation;
        }
    }

    public static DbRepresentation of(Path databaseDirectory) {
        return DbRepresentation.of(databaseDirectory, Config.defaults());
    }

    public static DbRepresentation of(Path databaseDirectory, Config config) {
        return DbRepresentation.of(databaseDirectory.getParent(), (String)config.get(GraphDatabaseSettings.initial_default_database), config);
    }

    public static DbRepresentation of(Path storeDirectory, String databaseName) {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.transaction_logs_root_path, (Object)storeDirectory.toAbsolutePath());
        return DbRepresentation.of(storeDirectory, databaseName, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbRepresentation of(Path storeDirectory, String databaseName, Config config) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDirectory).setConfig(config).noOpSystemGraphInitializer().build();
        GraphDatabaseService db = managementService.database(databaseName);
        try {
            DbRepresentation dbRepresentation = DbRepresentation.of(db);
            return dbRepresentation;
        }
        finally {
            managementService.shutdown();
        }
    }

    public static DbRepresentation of(DatabaseLayout databaseLayout) {
        Neo4jLayout layout = databaseLayout.getNeo4jLayout();
        return DbRepresentation.of(databaseLayout.databaseDirectory(), Config.newBuilder().set(GraphDatabaseSettings.transaction_logs_root_path, (Object)layout.transactionLogsRootDirectory().toAbsolutePath()).set(GraphDatabaseInternalSettings.databases_root_path, (Object)layout.databasesDirectory().toAbsolutePath()).set(GraphDatabaseSettings.initial_default_database, (Object)databaseLayout.getDatabaseName()).build());
    }

    public static DbRepresentation of(DatabaseLayout databaseLayout, Config config) {
        Neo4jLayout layout = databaseLayout.getNeo4jLayout();
        Config cfg = Config.newBuilder().fromConfig(config).setDefault(GraphDatabaseSettings.transaction_logs_root_path, (Object)layout.transactionLogsRootDirectory().toAbsolutePath()).setDefault(GraphDatabaseInternalSettings.databases_root_path, (Object)layout.databasesDirectory().toAbsolutePath()).setDefault(GraphDatabaseSettings.initial_default_database, (Object)databaseLayout.getDatabaseName()).build();
        return DbRepresentation.of(databaseLayout.databaseDirectory(), cfg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbRepresentation other = (DbRepresentation)o;
        return this.compareWith(other).isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.schemaIndexes, this.constraints, this.highestNodeId, this.highestRelationshipId);
    }

    public String toString() {
        return "DbRepresentation{nodes=" + this.nodes + ", schemaIndexes=" + this.schemaIndexes + ", constraints=" + this.constraints + ", highestNodeId=" + this.highestNodeId + ", highestRelationshipId=" + this.highestRelationshipId + "}";
    }

    public Collection<String> compareWith(DbRepresentation other) {
        ArrayList<String> diffList = new ArrayList<String>();
        CollectionDiffReport diff = new CollectionDiffReport(diffList);
        this.nodeDiff(other, diff);
        this.indexDiff(other, diff);
        this.constraintDiff(other, diff);
        return diffList;
    }

    private void constraintDiff(DbRepresentation other, DiffReport diff) {
        for (ConstraintDefinition constraint : this.constraints) {
            if (other.constraints.contains(constraint)) continue;
            diff.add("I have constraint " + constraint + " which other doesn't");
        }
        for (ConstraintDefinition otherConstraint : other.constraints) {
            if (this.constraints.contains(otherConstraint)) continue;
            diff.add("Other has constraint " + otherConstraint + " which I don't");
        }
    }

    private void indexDiff(DbRepresentation other, DiffReport diff) {
        for (IndexDefinition schemaIndex : this.schemaIndexes) {
            if (other.schemaIndexes.contains(schemaIndex)) continue;
            diff.add("I have schema index " + schemaIndex + " which other doesn't");
        }
        for (IndexDefinition otherSchemaIndex : other.schemaIndexes) {
            if (this.schemaIndexes.contains(otherSchemaIndex)) continue;
            diff.add("Other has schema index " + otherSchemaIndex + " which I don't");
        }
    }

    private void nodeDiff(DbRepresentation other, DiffReport diff) {
        for (NodeRep node : this.nodes.values()) {
            NodeRep otherNode = other.nodes.get(node.id);
            if (otherNode == null) {
                diff.add("I have node " + node.id + " which other doesn't");
                continue;
            }
            node.compareWith(otherNode, diff);
        }
        for (Long id : other.nodes.keySet()) {
            if (this.nodes.containsKey(id)) continue;
            diff.add("Other has node " + id + " which I don't");
        }
    }

    private static List<?> asList(Object propertyValue) {
        if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(propertyValue, i));
            }
            return result;
        }
        return List.of(propertyValue);
    }

    private static class NodeRep {
        private final PropertiesRep properties;
        private final Map<Long, PropertiesRep> outRelationships = new HashMap<Long, PropertiesRep>();
        private final long highestRelationshipId;
        private final long id;

        NodeRep(Node node) {
            this.id = node.getId();
            this.properties = new PropertiesRep((Entity)node, node.getId());
            long highestRel = 0L;
            try (ResourceIterable relationships = node.getRelationships(Direction.OUTGOING);){
                for (Relationship rel : relationships) {
                    this.outRelationships.put(rel.getId(), new PropertiesRep((Entity)rel, rel.getId()));
                    highestRel = Math.max(highestRel, rel.getId());
                }
            }
            this.highestRelationshipId = highestRel;
        }

        void compareWith(NodeRep other, DiffReport diff) {
            if (other.id != this.id) {
                diff.add("Id differs mine:" + this.id + ", other:" + other.id);
            }
            this.properties.compareWith(other.properties, diff);
            this.compareRelationships(other, diff);
        }

        private void compareRelationships(NodeRep other, DiffReport diff) {
            for (PropertiesRep rel : this.outRelationships.values()) {
                PropertiesRep otherRel = other.outRelationships.get(rel.entityId);
                if (otherRel == null) {
                    diff.add("I have relationship " + rel.entityId + " which other don't");
                    continue;
                }
                rel.compareWith(otherRel, diff);
            }
            for (Long relId : other.outRelationships.keySet()) {
                if (this.outRelationships.containsKey(relId)) continue;
                diff.add("Other has relationship " + relId + " which I don't");
            }
        }

        public int hashCode() {
            int result = 7;
            result += this.properties.hashCode() * 7;
            result += this.outRelationships.hashCode() * 13;
            result = (int)((long)result + this.id * 17L);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeRep nodeRep = (NodeRep)o;
            return this.id == nodeRep.id && Objects.equals(this.properties, nodeRep.properties) && Objects.equals(this.outRelationships, nodeRep.outRelationships);
        }

        public String toString() {
            return "<id: " + this.id + " props: " + this.properties + ", rels: " + this.outRelationships;
        }
    }

    private record CollectionDiffReport(Collection<String> collection) implements DiffReport
    {
        @Override
        public void add(String report) {
            this.collection.add(report);
        }
    }

    private static interface DiffReport {
        public void add(String var1);
    }

    private static class PropertiesRep {
        private final Map<String, Object> props = new HashMap<String, Object>();
        private final String entityToString;
        private final long entityId;

        PropertiesRep(Entity entity, long id) {
            this.entityId = id;
            this.entityToString = entity.toString();
            for (String key : entity.getPropertyKeys()) {
                Object value = entity.getProperty(key, null);
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    this.props.put(key, DbRepresentation.asList(value));
                    continue;
                }
                this.props.put(key, value);
            }
        }

        protected void compareWith(PropertiesRep other, DiffReport diff) {
            boolean equals = this.props.equals(other.props);
            if (!equals) {
                diff.add("Properties diff for " + this.entityToString + " mine:" + this.props + ", other:" + other.props);
            }
        }

        public int hashCode() {
            return this.props.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertiesRep that = (PropertiesRep)o;
            return Objects.equals(this.props, that.props);
        }

        public String toString() {
            return this.props.toString();
        }
    }
}

