/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.snapshot;

import java.io.PrintStream;
import java.util.function.LongSupplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.impl.context.TransactionVersionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TestVersionContext
extends TransactionVersionContext {
    private boolean wrongLastClosedTxId = true;
    private int numIsDirtyCalls;
    private int additionalAttempts;
    private boolean stayDirty;
    private Exception lastMarkAsDirtyCall;
    private Exception additionalAttemptsCall;
    private final String databaseName;

    public TestVersionContext(LongSupplier transactionIdSupplier, String databaseName) {
        super(transactionIdSupplier);
        this.databaseName = databaseName;
    }

    public long lastClosedTransactionId() {
        return this.wrongLastClosedTxId ? 1L : super.lastClosedTransactionId();
    }

    public void markAsDirty() {
        super.markAsDirty();
        if (!this.stayDirty) {
            this.wrongLastClosedTxId = false;
        }
        this.lastMarkAsDirtyCall = new Exception("markAsDirty");
    }

    public boolean isDirty() {
        ++this.numIsDirtyCalls;
        boolean dirty = super.isDirty();
        if (dirty) {
            ++this.additionalAttempts;
            this.additionalAttemptsCall = new Exception("isDirty");
        }
        return dirty;
    }

    public void printDirtyCalls(PrintStream printStream) {
        if (this.lastMarkAsDirtyCall != null) {
            this.lastMarkAsDirtyCall.printStackTrace(printStream);
        } else {
            printStream.println("No last markAsDirty call");
        }
        if (this.additionalAttemptsCall != null) {
            this.additionalAttemptsCall.printStackTrace(printStream);
        } else {
            printStream.println("No additionalAttempts call");
        }
    }

    public int getNumIsDirtyCalls() {
        return this.numIsDirtyCalls;
    }

    public int getAdditionalAttempts() {
        return this.additionalAttempts;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setWrongLastClosedTxId(boolean wrongLastClosedTxId) {
        this.wrongLastClosedTxId = wrongLastClosedTxId;
    }

    public void stayDirty(boolean stayDirty) {
        this.stayDirty = stayDirty;
    }

    public static TestVersionContext testCursorContext(LongSupplier idSupplier, String databaseName) {
        return new TestVersionContext(idSupplier, databaseName);
    }

    public static TestVersionContext testCursorContext(DatabaseManagementService managementService, String databaseName) {
        TransactionIdStore transactionIdStore = TestVersionContext.getTransactionIdStore(managementService, databaseName);
        return new TestVersionContext(() -> ((TransactionIdStore)transactionIdStore).getLastClosedTransactionId(), databaseName);
    }

    private static TransactionIdStore getTransactionIdStore(DatabaseManagementService managementService, String databaseName) {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)managementService.database(databaseName)).getDependencyResolver();
        return (TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class);
    }
}

