/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.fabric;

import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManagementServiceImpl;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.fabric.bolt.BoltFabricDatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceFactory;
import org.neo4j.test.fabric.TestFabricGraphDatabaseService;
import org.neo4j.time.SystemNanoClock;

public class TestFabricDatabaseManagementServiceFactory
extends TestDatabaseManagementServiceFactory {
    private final Config config;

    public TestFabricDatabaseManagementServiceFactory(DbmsInfo dbmsInfo, Function<GlobalModule, AbstractEditionModule> editionFactory, boolean impermanent, FileSystemAbstraction fileSystem, SystemNanoClock clock, LogProvider internalLogProvider, Config config) {
        super(dbmsInfo, editionFactory, impermanent, fileSystem, clock, internalLogProvider);
        this.config = config;
    }

    protected DatabaseManagementService createManagementService(final GlobalModule globalModule, LifeSupport globalLife, Log internalLog, final DatabaseManager<?> databaseManager) {
        return new DatabaseManagementServiceImpl(databaseManager, (Lifecycle)globalLife, globalModule.getDatabaseEventListeners(), globalModule.getTransactionEventListeners(), internalLog, globalModule.getGlobalConfig()){

            public GraphDatabaseService database(String name) throws DatabaseNotFoundException {
                BoltFabricDatabaseManagementService fabricBoltDbms = (BoltFabricDatabaseManagementService)globalModule.getGlobalDependencies().resolveDependency(BoltFabricDatabaseManagementService.class);
                GraphDatabaseFacade baseDb = ((DatabaseContext)databaseManager.getDatabaseContext(name).orElseThrow(() -> new DatabaseNotFoundException(name))).databaseFacade();
                return new TestFabricGraphDatabaseService(baseDb, TestFabricDatabaseManagementServiceFactory.this.config, () -> {
                    try {
                        return fabricBoltDbms.getDatabase(name, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    }
                    catch (UnavailableException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        };
    }
}

