/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.RandomStringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.util.Preconditions;

public final class TestDatabaseIdRepository {
    private TestDatabaseIdRepository() {
    }

    public static NamedDatabaseId randomNamedDatabaseId() {
        return new NamedDatabaseId(RandomStringUtils.randomAlphabetic((int)20), UUID.randomUUID());
    }

    public static DatabaseId randomDatabaseId() {
        return new DatabaseId(UUID.randomUUID());
    }

    private static class Random
    implements DatabaseIdRepository {
        private Random() {
        }

        public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
            return Optional.of(new NamedDatabaseId(databaseName.name(), UUID.randomUUID()));
        }

        public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
            return Optional.of(new NamedDatabaseId("db" + databaseId.hashCode(), databaseId.uuid()));
        }
    }

    public static class Caching
    extends MapCachingDatabaseIdRepository {
        private final String defaultDatabaseName;
        private final Set<String> filterSet = new CopyOnWriteArraySet<String>();

        public Caching() {
            this("neo4j");
        }

        public Caching(Config config) {
            this((String)config.get(GraphDatabaseSettings.default_database));
        }

        public Caching(String defaultDbName) {
            super((DatabaseIdRepository)new Random());
            this.defaultDatabaseName = defaultDbName;
        }

        public NamedDatabaseId defaultDatabase() {
            return this.getRaw(this.defaultDatabaseName);
        }

        public NamedDatabaseId getRaw(String databaseName) {
            Optional databaseIdOpt = this.getByName(databaseName);
            Preconditions.checkState((boolean)databaseIdOpt.isPresent(), (String)(((Object)((Object)this)).getClass().getSimpleName() + " should always produce a " + NamedDatabaseId.class.getSimpleName() + " for any database name"));
            return (NamedDatabaseId)databaseIdOpt.get();
        }

        public void filter(String databaseName) {
            this.filterSet.add(databaseName);
        }

        public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
            Optional id = super.getByName(databaseName);
            Boolean nameIsFiltered = id.map(NamedDatabaseId::name).map(this.filterSet::contains).orElse(false);
            return nameIsFiltered != false ? Optional.empty() : id;
        }

        public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
            Optional id = super.getById(databaseId);
            Boolean uuidIsFiltered = id.map(i -> this.filterSet.contains(i.name())).orElse(false);
            return uuidIsFiltered != false ? Optional.empty() : id;
        }
    }
}

