/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;
import org.neo4j.test.utils.TestDirectory;

public class Neo4jWithSocket {
    static final String NEO4J_WITH_SOCKET = "org.neo4j.bolt.transport.Neo4jWithSocket";
    private final Supplier<FileSystemAbstraction> fileSystemProvider;
    private Consumer<Map<Setting<?>, Object>> configure;
    private final TestDirectory testDirectory;
    private TestDatabaseManagementServiceBuilder graphDatabaseFactory;
    private GraphDatabaseService gdb;
    private Path workingDirectory;
    private ConnectorPortRegister connectorRegister;
    private DatabaseManagementService managementService;

    public Neo4jWithSocket(TestDatabaseManagementServiceBuilder graphDatabaseFactory, Supplier<TestDirectory> testDirectorySupplier, Consumer<Map<Setting<?>, Object>> configure) {
        this.testDirectory = testDirectorySupplier.get();
        this.graphDatabaseFactory = graphDatabaseFactory;
        this.fileSystemProvider = () -> ((TestDirectory)this.testDirectory).getFileSystem();
        this.configure = configure;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.graphDatabaseFactory.getFileSystem();
    }

    public DatabaseManagementService getManagementService() {
        return this.managementService;
    }

    public void setConfigure(Consumer<Map<Setting<?>, Object>> configure) {
        this.configure = configure;
    }

    public void setGraphDatabaseFactory(TestDatabaseManagementServiceBuilder graphDatabaseFactory) {
        this.graphDatabaseFactory = graphDatabaseFactory;
    }

    public void init(TestInfo testInfo) throws IOException {
        String testName = ((Method)testInfo.getTestMethod().get()).getName();
        this.testDirectory.prepareDirectory((Class)testInfo.getTestClass().get(), testName);
        this.workingDirectory = this.testDirectory.directory(testName);
        this.ensureDatabase(settings -> {});
    }

    public HostnamePort lookupConnector(String connectorKey) {
        return this.connectorRegister.getLocalAddress(connectorKey);
    }

    public HostnamePort lookupDefaultConnector() {
        return this.connectorRegister.getLocalAddress("bolt");
    }

    public void shutdownDatabase() {
        try {
            if (this.managementService != null) {
                this.managementService.shutdown();
            }
        }
        finally {
            this.connectorRegister = null;
            this.gdb = null;
            this.managementService = null;
        }
    }

    public void ensureDatabase(Consumer<Map<Setting<?>, Object>> overrideSettingsFunction) {
        if (this.gdb != null) {
            return;
        }
        Map<Setting<?>, Object> settings = this.configure(overrideSettingsFunction);
        Path storeDir = this.workingDirectory.resolve("storeDir");
        this.installSelfSignedCertificateIfEncryptionEnabled(settings);
        this.graphDatabaseFactory.setFileSystem(this.fileSystemProvider.get());
        this.managementService = this.graphDatabaseFactory.setDatabaseRootDirectory(storeDir).impermanent().setConfig((Map)settings).build();
        this.gdb = this.managementService.database("neo4j");
        this.connectorRegister = (ConnectorPortRegister)((GraphDatabaseAPI)this.gdb).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }

    private void installSelfSignedCertificateIfEncryptionEnabled(Map<Setting<?>, Object> settings) {
        Object encryptionLevel = settings.get(BoltConnector.encryption_level);
        if (encryptionLevel != BoltConnector.EncryptionLevel.DISABLED) {
            Path certificates = this.workingDirectory.resolve("certificates");
            SelfSignedCertificateFactory.create((Path)certificates);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT).enabled, Boolean.TRUE);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT).base_directory, certificates);
        }
        SslPolicyConfig clusterConfig = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER);
        if (settings.containsKey(clusterConfig.enabled)) {
            Path clusterCertificates = this.workingDirectory.resolve("cluster-cert");
            SelfSignedCertificateFactory.create((Path)clusterCertificates);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER).enabled, Boolean.TRUE);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER).base_directory, clusterCertificates);
        }
    }

    private Map<Setting<?>, Object> configure(Consumer<Map<Setting<?>, Object>> overrideSettingsFunction) {
        HashMap settings = new HashMap();
        settings.put(GraphDatabaseSettings.auth_enabled, false);
        settings.put(BoltConnector.enabled, true);
        settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED);
        this.configure.accept(settings);
        overrideSettingsFunction.accept(settings);
        return settings;
    }

    public static Consumer<Map<Setting<?>, Object>> withOptionalBoltEncryption() {
        return settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
    }

    public GraphDatabaseService graphDatabaseService() {
        return this.gdb;
    }
}

