/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.fabric;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.cypher.internal.javacompat.ResultSubscriber;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.fabric.TestFabricTransactionalContext;
import org.neo4j.values.virtual.MapValue;

public class TestFabricTransaction
implements InternalTransaction {
    private final BoltTransaction fabricTransaction;
    private final InternalTransaction kernelInternalTransaction;

    TestFabricTransaction(BoltTransaction transaction, InternalTransaction kernelInternalTransaction) {
        this.fabricTransaction = transaction;
        this.kernelInternalTransaction = kernelInternalTransaction;
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Map.of());
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        TestFabricTransactionalContext ctx = new TestFabricTransactionalContext(this.kernelInternalTransaction);
        MapValue params = ValueUtils.asParameterMapValue(parameters);
        ResultSubscriber result = new ResultSubscriber((TransactionalContext)ctx, ctx.valueMapper());
        try {
            BoltQueryExecution boltQueryExecution = this.fabricTransaction.executeQuery(query, params, false, (QuerySubscriber)result);
            result.init(boltQueryExecution.getQueryExecution());
        }
        catch (FabricException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new QueryExecutionException(e.getMessage(), (Throwable)e, e.status().code().serialize());
        }
        catch (Neo4jException | QueryExecutionKernelException e) {
            throw new QueryExecutionException(e.getMessage(), e, ((Status.HasStatus)e).status().code().serialize());
        }
        return result;
    }

    public void terminate() {
        this.terminate((Status)Status.Transaction.Terminated);
    }

    public void terminate(Status reason) {
        this.fabricTransaction.markForTermination(reason);
    }

    public UUID getDatabaseId() {
        return this.kernelInternalTransaction.getDatabaseId();
    }

    public String getDatabaseName() {
        return this.kernelInternalTransaction.getDatabaseName();
    }

    public <E extends Entity> E validateSameDB(E entity) {
        return (E)this.kernelInternalTransaction.validateSameDB(entity);
    }

    public void commit() {
        try {
            this.fabricTransaction.commit();
        }
        catch (FabricException e) {
            throw this.unwrapFabricException(e);
        }
        catch (TransactionFailureException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unable to complete transaction.", (Throwable)e);
        }
    }

    public void rollback() {
        try {
            this.fabricTransaction.rollback();
        }
        catch (FabricException e) {
            throw this.unwrapFabricException(e);
        }
        catch (TransactionFailureException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unable to complete transaction.", (Throwable)e);
        }
    }

    private RuntimeException unwrapFabricException(FabricException e) {
        if (e.getCause() instanceof RuntimeException) {
            return (RuntimeException)e.getCause();
        }
        return e;
    }

    public void close() {
        if (this.kernelInternalTransaction.isOpen()) {
            try {
                this.fabricTransaction.rollback();
            }
            catch (TransactionFailureException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Node createNode() {
        return this.kernelInternalTransaction.createNode();
    }

    public Node createNode(Label ... labels) {
        return this.kernelInternalTransaction.createNode(labels);
    }

    public Node getNodeById(long id) {
        return this.kernelInternalTransaction.getNodeById(id);
    }

    public Relationship getRelationshipById(long id) {
        return this.kernelInternalTransaction.getRelationshipById(id);
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return this.kernelInternalTransaction.bidirectionalTraversalDescription();
    }

    public TraversalDescription traversalDescription() {
        return this.kernelInternalTransaction.traversalDescription();
    }

    public Iterable<Label> getAllLabelsInUse() {
        return this.kernelInternalTransaction.getAllLabelsInUse();
    }

    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.kernelInternalTransaction.getAllRelationshipTypesInUse();
    }

    public Iterable<Label> getAllLabels() {
        return this.kernelInternalTransaction.getAllLabels();
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.kernelInternalTransaction.getAllRelationshipTypes();
    }

    public Iterable<String> getAllPropertyKeys() {
        return this.kernelInternalTransaction.getAllPropertyKeys();
    }

    public ResourceIterator<Node> findNodes(Label label, String key, String template, StringSearchMode searchMode) {
        return this.kernelInternalTransaction.findNodes(label, key, template, searchMode);
    }

    public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        return this.kernelInternalTransaction.findNodes(label, propertyValues);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return this.kernelInternalTransaction.findNodes(label, key1, value1, key2, value2, key3, value3);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        return this.kernelInternalTransaction.findNodes(label, key1, value1, key2, value2);
    }

    public Node findNode(Label label, String key, Object value) {
        return this.kernelInternalTransaction.findNode(label, key, value);
    }

    public ResourceIterator<Node> findNodes(Label label, String key, Object value) {
        return this.kernelInternalTransaction.findNodes(label, key, value);
    }

    public ResourceIterator<Node> findNodes(Label label) {
        return this.kernelInternalTransaction.findNodes(label);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key, String template, StringSearchMode searchMode) {
        return this.kernelInternalTransaction.findRelationships(relationshipType, key, template, searchMode);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, Map<String, Object> propertyValues) {
        return this.kernelInternalTransaction.findRelationships(relationshipType, propertyValues);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return this.kernelInternalTransaction.findRelationships(relationshipType, key1, value1, key2, value2, key3, value3);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key1, Object value1, String key2, Object value2) {
        return this.kernelInternalTransaction.findRelationships(relationshipType, key1, value1, key2, value2);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key, Object value) {
        return this.kernelInternalTransaction.findRelationships(relationshipType, key, value);
    }

    public Relationship findRelationship(RelationshipType relationshipType, String key, Object value) {
        return this.kernelInternalTransaction.findRelationship(relationshipType, key, value);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType) {
        return this.kernelInternalTransaction.findRelationships(relationshipType);
    }

    public ResourceIterable<Node> getAllNodes() {
        return this.kernelInternalTransaction.getAllNodes();
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        return this.kernelInternalTransaction.getAllRelationships();
    }

    public Lock acquireWriteLock(Entity entity) {
        return this.kernelInternalTransaction.acquireWriteLock(entity);
    }

    public Lock acquireReadLock(Entity entity) {
        return this.kernelInternalTransaction.acquireReadLock(entity);
    }

    public Schema schema() {
        return this.kernelInternalTransaction.schema();
    }

    public void setTransaction(KernelTransaction transaction) {
        this.kernelInternalTransaction.setTransaction(transaction);
    }

    public KernelTransaction kernelTransaction() {
        return this.kernelInternalTransaction.kernelTransaction();
    }

    public KernelTransaction.Type transactionType() {
        return this.kernelInternalTransaction.transactionType();
    }

    public SecurityContext securityContext() {
        return this.kernelInternalTransaction.securityContext();
    }

    public ClientConnectionInfo clientInfo() {
        return this.kernelInternalTransaction.clientInfo();
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.kernelInternalTransaction.overrideWith(context);
    }

    public Optional<Status> terminationReason() {
        return this.kernelInternalTransaction.terminationReason();
    }

    public void setMetaData(Map<String, Object> txMeta) {
        this.kernelInternalTransaction.setMetaData(txMeta);
    }

    public void checkInTransaction() {
        this.kernelInternalTransaction.checkInTransaction();
    }

    public boolean isOpen() {
        return this.kernelInternalTransaction.isOpen();
    }

    public Relationship newRelationshipEntity(long id) {
        return this.kernelInternalTransaction.newRelationshipEntity(id);
    }

    public Relationship newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
        return this.kernelInternalTransaction.newRelationshipEntity(id, startNodeId, typeId, endNodeId);
    }

    public Node newNodeEntity(long nodeId) {
        return this.kernelInternalTransaction.newNodeEntity(nodeId);
    }

    public RelationshipType getRelationshipTypeById(int type) {
        return this.kernelInternalTransaction.getRelationshipTypeById(type);
    }
}

