/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.storageengine.api.StorageEngineFactory;

public final class RecoveryHelpers {
    private RecoveryHelpers() {
    }

    public static void removeLastCheckpointRecordFromLastLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        LogFiles logFiles = RecoveryHelpers.buildLogFiles(dbLayout, fs);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        Optional latestCheckpoint = checkpointFile.findLatestCheckpoint();
        latestCheckpoint.ifPresent(checkpointInfo -> {
            LogPosition entryPosition = checkpointInfo.getCheckpointEntryPosition();
            try (StoreChannel storeChannel = fs.write(checkpointFile.getCurrentFile());){
                storeChannel.truncate(entryPosition.getByteOffset());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static LogFiles buildLogFiles(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)dbLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)fs).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine().commandReaderFactory()).build();
    }
}

