/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.BoltDbmsExtension;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.DbmsSupportExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.rule.TestDirectory;

public class DbmsSupportController {
    private static final String DBMS_KEY = "service";
    private static final String CONTROLLER_KEY = "controller";
    private static final ExtensionContext.Namespace DBMS_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"org", "neo4j", "dbms"});
    private final ExtensionContext context;
    private final TestInstances testInstances;
    private DatabaseManagementService dbms;

    public DbmsSupportController(ExtensionContext context) {
        this.context = context;
        this.testInstances = context.getRequiredTestInstances();
        DbmsSupportController.getStore(context).put((Object)CONTROLLER_KEY, (Object)this);
    }

    public static DbmsSupportController get(ExtensionContext context) {
        return (DbmsSupportController)DbmsSupportController.getStore(context).get((Object)CONTROLLER_KEY, DbmsSupportController.class);
    }

    public static DbmsSupportController remove(ExtensionContext context) {
        return (DbmsSupportController)DbmsSupportController.getStore(context).remove((Object)CONTROLLER_KEY, DbmsSupportController.class);
    }

    public final void startDbms() {
        this.startDbms("", UnaryOperator.identity());
    }

    public void startDbms(String databaseName, UnaryOperator<TestDatabaseManagementServiceBuilder> callback) {
        TestConfiguration configuration = DbmsSupportController.getConfigurationFromAnnotations(this.getTestAnnotation(DbmsExtension.class), this.getTestAnnotation(ImpermanentDbmsExtension.class), this.getTestAnnotation(BoltDbmsExtension.class));
        DatabaseManagementService dbms = this.buildDbms(configuration, callback);
        String databaseToStart = StringUtils.isNotEmpty((CharSequence)databaseName) ? databaseName : this.getDatabaseName(dbms);
        this.startDatabase(databaseToStart);
    }

    protected String getDatabaseName(DatabaseManagementService dbms) {
        ArrayList databases = new ArrayList(dbms.listDatabases());
        databases.remove("system");
        return (String)databases.get(0);
    }

    public void startDatabase(String databaseName) {
        if (!this.dbms.listDatabases().contains(databaseName)) {
            this.dbms.createDatabase(databaseName);
        }
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database(databaseName);
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        this.injectDependencies(dependencyResolver);
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(new Object[]{this.asDbmsController()});
        this.injectDependencies((DependencyResolver)deps);
    }

    public void stopDatabase(String databaseName) {
        this.dbms.shutdownDatabase(databaseName);
    }

    public void restartDatabase(String databaseName) {
        this.stopDatabase(databaseName);
        this.startDatabase(databaseName);
    }

    public TestDirectory getTestDirectory() {
        TestDirectory testDir = (TestDirectory)this.context.getStore(TestDirectorySupportExtension.TEST_DIRECTORY_NAMESPACE).get((Object)"testDirectory", TestDirectory.class);
        if (testDir == null) {
            String tdClassName = TestDirectorySupportExtension.class.getSimpleName();
            String dbClassName = DbmsSupportExtension.class.getSimpleName();
            throw new IllegalStateException(tdClassName + " not in scope, make sure to add it before the relevant " + dbClassName);
        }
        return testDir;
    }

    public <T extends Annotation> Optional<T> getTestAnnotation(Class<T> annotationType) {
        return this.context.getTestMethod().map(m -> m.getAnnotation(annotationType)).or(() -> this.context.getTestClass().map(cls -> cls.getAnnotation(annotationType)));
    }

    protected DatabaseManagementService buildDbms(TestConfiguration testConfiguration, UnaryOperator<TestDatabaseManagementServiceBuilder> callback) {
        TestDirectory testDir = this.getTestDirectory();
        TestDatabaseManagementServiceBuilder builder = this.createBuilder(testDir.homePath(), testDir.getFileSystem());
        testConfiguration.implicitConfigurationCallback.accept(builder);
        DbmsSupportController.maybeInvokeCallback(this.testInstances.getInnermostInstance(), builder, testConfiguration.configurationCallback);
        builder = (TestDatabaseManagementServiceBuilder)((Object)callback.apply(builder));
        this.dbms = builder.build();
        ExtensionContext.Store store = DbmsSupportController.getStore(this.context);
        store.put((Object)DBMS_KEY, (Object)this.dbms);
        return this.dbms;
    }

    public TestDatabaseManagementServiceBuilder createBuilder(Path homeDirectory, FileSystemAbstraction fileSystem) {
        return new TestDatabaseManagementServiceBuilder(homeDirectory).setFileSystem(fileSystem);
    }

    public void injectDependencies(DependencyResolver dependencyResolver) {
        for (Object testInstance : this.testInstances.getAllInstances()) {
            List<Field> injectableFields = DbmsSupportController.lookupInjectableFields(testInstance);
            DbmsSupportController.injectInstance(testInstance, injectableFields, dependencyResolver);
        }
    }

    public void shutdown() {
        DatabaseManagementService databaseManagementService = (DatabaseManagementService)DbmsSupportController.getStore(this.context).remove((Object)DBMS_KEY, DatabaseManagementService.class);
        databaseManagementService.shutdown();
    }

    public DbmsController asDbmsController() {
        return new DbmsController(){

            @Override
            public void restartDbms(String databaseName, UnaryOperator<TestDatabaseManagementServiceBuilder> callback) {
                DbmsSupportController.this.shutdown();
                try {
                    DbmsSupportController.this.startDbms(databaseName, callback);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void restartDatabase(String databaseName) {
                this.restartDbms(databaseName);
            }
        };
    }

    private static List<Field> lookupInjectableFields(Object testInstance) {
        return FieldUtils.getFieldsListWithAnnotation(testInstance.getClass(), Inject.class);
    }

    private static void injectInstance(Object testInstance, List<Field> injectables, DependencyResolver dependencies) {
        for (Field injectable : injectables) {
            Class<?> fieldType = injectable.getType();
            if (!dependencies.resolveTypeDependencies(fieldType).iterator().hasNext()) continue;
            DbmsSupportController.setField(testInstance, injectable, dependencies.resolveDependency(fieldType));
        }
    }

    private static void setField(Object testInstance, Field field, Object db) {
        field.setAccessible(true);
        try {
            field.set(testInstance, db);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void maybeInvokeCallback(Object testInstance, TestDatabaseManagementServiceBuilder builder, String callback) {
        if (callback == null || callback.isEmpty()) {
            return;
        }
        for (Method method : DbmsSupportController.getAllMethods(testInstance.getClass())) {
            if (!method.getName().equals(callback)) continue;
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("The method '" + callback + "', must return void.");
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(TestDatabaseManagementServiceBuilder.class)) {
                throw new IllegalArgumentException("The method '" + callback + "', must take one parameter that is assignable from " + TestDatabaseManagementServiceBuilder.class.getSimpleName() + ".");
            }
            if (method.getAnnotation(ExtensionCallback.class) == null) {
                throw new IllegalArgumentException("The method '" + callback + "', must be annotated with " + ExtensionCallback.class.getSimpleName() + ".");
            }
            method.setAccessible(true);
            try {
                method.invoke(testInstance, new Object[]{builder});
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The method '" + callback + "' is not accessible.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("The method '" + callback + "' threw an exception.", e);
            }
            return;
        }
        throw new IllegalArgumentException("The method with name '" + callback + "' cannot be found.");
    }

    private static Iterable<? extends Method> getAllMethods(Class<?> clazz) {
        ArrayList methods = new ArrayList();
        Collections.addAll(methods, clazz.getDeclaredMethods());
        List classes = ClassUtils.getAllSuperclasses(clazz);
        for (Class aClass : classes) {
            Collections.addAll(methods, aClass.getDeclaredMethods());
        }
        return methods;
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(DBMS_NAMESPACE);
    }

    @SafeVarargs
    private static TestConfiguration getConfigurationFromAnnotations(Optional<? extends Annotation> ... options) {
        Object[] annotations = (Annotation[])Arrays.stream(options).flatMap(Optional::stream).toArray(Annotation[]::new);
        if (annotations.length > 1) {
            throw new IllegalArgumentException("Multiple DBMS annotations found for the configuration: " + Arrays.toString(annotations) + ".");
        }
        if (annotations.length == 1) {
            if (annotations[0] instanceof DbmsExtension) {
                DbmsExtension annotation = (DbmsExtension)annotations[0];
                return new TestConfiguration(annotation.configurationCallback());
            }
            if (annotations[0] instanceof ImpermanentDbmsExtension) {
                ImpermanentDbmsExtension annotation = (ImpermanentDbmsExtension)annotations[0];
                return new TestConfiguration(annotation.configurationCallback());
            }
            if (annotations[0] instanceof BoltDbmsExtension) {
                BoltDbmsExtension annotation = (BoltDbmsExtension)annotations[0];
                return new TestConfiguration(annotation.configurationCallback(), dbmsBuilder -> dbmsBuilder.setConfig(BoltConnector.enabled, Boolean.TRUE).overrideDefaultSetting(BoltConnector.listen_address, new SocketAddress("localhost", 0)));
            }
        }
        return new TestConfiguration(null);
    }

    protected static class TestConfiguration {
        private final String configurationCallback;
        private final Consumer<TestDatabaseManagementServiceBuilder> implicitConfigurationCallback;

        public TestConfiguration(String configurationCallback) {
            this(configurationCallback, dbmsBuilder -> {});
        }

        public TestConfiguration(String configurationCallback, Consumer<TestDatabaseManagementServiceBuilder> implicitConfigurationCallback) {
            this.configurationCallback = configurationCallback;
            this.implicitConfigurationCallback = implicitConfigurationCallback;
        }
    }
}

