/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.rule.ExternalResource;

public abstract class DbmsRule
extends ExternalResource
implements GraphDatabaseAPI {
    private DatabaseManagementServiceBuilder databaseBuilder;
    private GraphDatabaseAPI database;
    private DatabaseLayout databaseLayout;
    private boolean startEagerly = true;
    private final Map<Setting<?>, Object> globalConfig = new HashMap();
    private final Monitors monitors = new Monitors();
    private DatabaseManagementService managementService;

    public DbmsRule startLazily() {
        this.startEagerly = false;
        return this;
    }

    public <T> T executeAndCommit(Function<Transaction, T> function) {
        return this.transaction(function, true);
    }

    public <T> T executeAndRollback(Function<Transaction, T> function) {
        return this.transaction(function, false);
    }

    public <FROM, TO> Function<FROM, TO> tx(Function<FROM, TO> function) {
        return from -> {
            Function<Transaction, Object> inner = graphDb -> function.apply(from);
            return this.executeAndCommit(inner);
        };
    }

    private <T> T transaction(Function<Transaction, T> function, boolean commit) {
        return DbmsRule.tx((GraphDatabaseService)this.getGraphDatabaseAPI(), commit, function);
    }

    public static void tx(GraphDatabaseService db, Consumer<Transaction> transaction) {
        Function<Transaction, Void> voidFunction = tx -> {
            transaction.accept((Transaction)tx);
            return null;
        };
        DbmsRule.tx(db, true, voidFunction);
    }

    public static <T> T tx(GraphDatabaseService db, boolean commit, Function<Transaction, T> transaction) {
        try (Transaction tx = db.beginTx();){
            T result = transaction.apply(tx);
            if (commit) {
                tx.commit();
            }
            T t = result;
            return t;
        }
    }

    public void executeTransactionally(String query) throws QueryExecutionException {
        this.getGraphDatabaseAPI().executeTransactionally(query);
    }

    public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.getGraphDatabaseAPI().executeTransactionally(query, parameters);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
        return (T)this.getGraphDatabaseAPI().executeTransactionally(query, parameters, resultTransformer);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
        return (T)this.getGraphDatabaseAPI().executeTransactionally(query, parameters, resultTransformer, timeout);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext, connectionInfo);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeout, TimeUnit unit) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext, connectionInfo, timeout, unit);
    }

    public Transaction beginTx() {
        return this.getGraphDatabaseAPI().beginTx();
    }

    public Transaction beginTx(long timeout, TimeUnit timeUnit) {
        return this.getGraphDatabaseAPI().beginTx(timeout, timeUnit);
    }

    protected void before() {
        this.create();
        if (this.startEagerly) {
            this.ensureStarted();
        }
    }

    protected void after(boolean success) {
        this.shutdown(success);
    }

    private void create() {
        this.createResources();
        try {
            this.databaseBuilder = this.newFactory();
            this.databaseBuilder.setMonitors(this.monitors);
            this.configure(this.databaseBuilder);
            this.databaseBuilder.setConfig(this.globalConfig);
        }
        catch (RuntimeException e) {
            this.deleteResources();
            throw e;
        }
    }

    public Monitors getMonitors() {
        return this.monitors;
    }

    protected void deleteResources() {
    }

    protected void createResources() {
    }

    protected abstract DatabaseManagementServiceBuilder newFactory();

    protected void configure(DatabaseManagementServiceBuilder databaseFactory) {
    }

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        this.ensureStarted();
        return this.database;
    }

    public DatabaseManagementService getManagementService() {
        return this.managementService;
    }

    public synchronized void ensureStarted() {
        if (this.database == null) {
            this.managementService = this.databaseBuilder.build();
            this.database = (GraphDatabaseAPI)this.managementService.database("neo4j");
            this.databaseLayout = this.database.databaseLayout();
        }
    }

    public <T> DbmsRule withSetting(Setting<T> key, T value) {
        if (this.database != null) {
            throw new IllegalStateException("Wanted to set " + key + "=" + value + ", but database has already been started");
        }
        if (this.databaseBuilder != null) {
            this.databaseBuilder.setConfig(key, value);
        } else {
            this.globalConfig.put(key, value);
        }
        return this;
    }

    public DbmsRule withSettings(Map<Setting<?>, Object> configuration) {
        if (this.database != null) {
            throw new IllegalStateException("Wanted to set " + configuration + ", but database has already been started");
        }
        if (this.databaseBuilder != null) {
            this.databaseBuilder.setConfig(configuration);
        } else {
            this.globalConfig.putAll(configuration);
        }
        return this;
    }

    public GraphDatabaseAPI restartDatabase() throws IOException {
        return this.restartDatabase(RestartAction.EMPTY, Map.of());
    }

    public GraphDatabaseAPI restartDatabase(Map<Setting<?>, Object> configChanges) throws IOException {
        return this.restartDatabase(RestartAction.EMPTY, configChanges);
    }

    public GraphDatabaseAPI restartDatabase(RestartAction action) throws IOException {
        return this.restartDatabase(action, Map.of());
    }

    public GraphDatabaseAPI restartDatabase(RestartAction action, Map<Setting<?>, Object> configChanges) throws IOException {
        FileSystemAbstraction fs = this.resolveDependency(FileSystemAbstraction.class);
        this.managementService.shutdown();
        action.run(fs, this.databaseLayout);
        this.database = null;
        this.databaseBuilder.setConfig(configChanges);
        return this.getGraphDatabaseAPI();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean deleteResources) {
        try {
            if (this.managementService != null) {
                this.managementService.shutdown();
            }
        }
        finally {
            if (deleteResources) {
                this.deleteResources();
            }
            this.managementService = null;
            this.database = null;
        }
    }

    public void shutdownAndKeepStore() {
        this.shutdown(false);
    }

    public <T> T resolveDependency(Class<T> type) {
        return (T)this.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(type);
    }

    public NamedDatabaseId databaseId() {
        return this.database.databaseId();
    }

    public DbmsInfo dbmsInfo() {
        return this.database.dbmsInfo();
    }

    public DependencyResolver getDependencyResolver() {
        return this.database.getDependencyResolver();
    }

    public DatabaseLayout databaseLayout() {
        return this.database.databaseLayout();
    }

    public boolean isAvailable(long timeout) {
        return this.database.isAvailable(timeout);
    }

    public String databaseName() {
        return this.database.databaseName();
    }

    public static interface RestartAction {
        public static final RestartAction EMPTY = (fs, storeDirectory) -> {};

        public void run(FileSystemAbstraction var1, DatabaseLayout var2) throws IOException;
    }
}

