/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.neo4j.dbms.DatabaseState;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.DefaultOperatorState;
import org.neo4j.dbms.OperatorState;
import org.neo4j.kernel.database.NamedDatabaseId;

public class StubDatabaseStateService
implements DatabaseStateService {
    private final Map<NamedDatabaseId, DatabaseState> databaseStates;

    public StubDatabaseStateService() {
        this.databaseStates = Collections.emptyMap();
    }

    public StubDatabaseStateService(Map<NamedDatabaseId, DatabaseState> databaseStates) {
        this.databaseStates = databaseStates;
    }

    public OperatorState stateOfDatabase(NamedDatabaseId namedDatabaseId) {
        DatabaseState state = this.databaseStates.get(namedDatabaseId);
        return state == null ? DefaultOperatorState.UNKNOWN : state.operatorState();
    }

    public Optional<Throwable> causeOfFailure(NamedDatabaseId namedDatabaseId) {
        return Optional.ofNullable(this.databaseStates.get(namedDatabaseId)).flatMap(DatabaseState::failure);
    }
}

