/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseBuilder;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.time.SystemNanoClock;

public class TestGraphDatabaseFactory
extends GraphDatabaseFactory {
    public static final Predicate<KernelExtensionFactory<?>> INDEX_PROVIDERS_FILTER = extension -> extension instanceof AbstractIndexProviderFactory;

    public TestGraphDatabaseFactory() {
        this((LogProvider)NullLogProvider.getInstance());
    }

    public TestGraphDatabaseFactory(LogProvider logProvider) {
        super((GraphDatabaseFactoryState)new TestGraphDatabaseFactoryState());
        this.setUserLogProvider(logProvider);
    }

    public GraphDatabaseService newImpermanentDatabase() {
        return this.newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    public GraphDatabaseService newImpermanentDatabase(File storeDir) {
        File absoluteDirectory = storeDir.getAbsoluteFile();
        GraphDatabaseBuilder databaseBuilder = this.newImpermanentDatabaseBuilder(absoluteDirectory);
        databaseBuilder.setConfig(GraphDatabaseSettings.active_database, absoluteDirectory.getName());
        databaseBuilder.setConfig(GraphDatabaseSettings.databases_root_path, absoluteDirectory.getParentFile().getAbsolutePath());
        return databaseBuilder.newGraphDatabase();
    }

    public GraphDatabaseService newImpermanentDatabase(Map<Setting<?>, String> config) {
        GraphDatabaseBuilder builder = this.newImpermanentDatabaseBuilder();
        this.setConfig(config, builder);
        return builder.newGraphDatabase();
    }

    public GraphDatabaseService newImpermanentDatabase(File storeDir, Map<Setting<?>, String> config) {
        GraphDatabaseBuilder builder = this.newImpermanentDatabaseBuilder(storeDir);
        this.setConfig(config, builder);
        return builder.newGraphDatabase();
    }

    private void setConfig(Map<Setting<?>, String> config, GraphDatabaseBuilder builder) {
        for (Map.Entry<Setting<?>, String> entry : config.entrySet()) {
            Setting<?> key = entry.getKey();
            String value = entry.getValue();
            builder.setConfig(key, value);
        }
    }

    public GraphDatabaseBuilder newImpermanentDatabaseBuilder() {
        return this.newImpermanentDatabaseBuilder(ImpermanentGraphDatabase.PATH);
    }

    protected void configure(GraphDatabaseBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
        builder.setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, "1s");
        builder.setConfig(new BoltConnector((String)"bolt").type, Connector.ConnectorType.BOLT.name());
        builder.setConfig(new BoltConnector((String)"bolt").enabled, "false");
    }

    private void configure(GraphDatabaseBuilder builder, File storeDir) {
        this.configure(builder);
        builder.setConfig(GraphDatabaseSettings.logs_directory, new File(storeDir, "logs").getAbsolutePath());
    }

    protected TestGraphDatabaseFactoryState getCurrentState() {
        return (TestGraphDatabaseFactoryState)super.getCurrentState();
    }

    protected TestGraphDatabaseFactoryState getStateCopy() {
        return new TestGraphDatabaseFactoryState(this.getCurrentState());
    }

    public FileSystemAbstraction getFileSystem() {
        return this.getCurrentState().getFileSystem();
    }

    public TestGraphDatabaseFactory setFileSystem(FileSystemAbstraction fileSystem) {
        this.getCurrentState().setFileSystem(fileSystem);
        return this;
    }

    public TestGraphDatabaseFactory setMonitors(Monitors monitors) {
        this.getCurrentState().setMonitors(monitors);
        return this;
    }

    public TestGraphDatabaseFactory setUserLogProvider(LogProvider logProvider) {
        return (TestGraphDatabaseFactory)super.setUserLogProvider(logProvider);
    }

    public TestGraphDatabaseFactory setInternalLogProvider(LogProvider logProvider) {
        this.getCurrentState().setInternalLogProvider(logProvider);
        return this;
    }

    public TestGraphDatabaseFactory setClock(SystemNanoClock clock) {
        this.getCurrentState().setClock(clock);
        return this;
    }

    public TestGraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().addKernelExtensions(newKernelExtensions);
        return this;
    }

    public TestGraphDatabaseFactory addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        return this.addKernelExtensions(Collections.singletonList(newKernelExtension));
    }

    public TestGraphDatabaseFactory setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().setKernelExtensions(newKernelExtensions);
        return this;
    }

    public TestGraphDatabaseFactory removeKernelExtensions(Predicate<KernelExtensionFactory<?>> filter) {
        this.getCurrentState().removeKernelExtensions(filter);
        return this;
    }

    public TestGraphDatabaseFactory addURLAccessRule(String protocol, URLAccessRule rule) {
        return (TestGraphDatabaseFactory)super.addURLAccessRule(protocol, rule);
    }

    public GraphDatabaseBuilder newImpermanentDatabaseBuilder(File storeDir) {
        TestGraphDatabaseFactoryState state = this.getStateCopy();
        GraphDatabaseBuilder.DatabaseCreator creator = this.createImpermanentDatabaseCreator(storeDir, state);
        TestGraphDatabaseBuilder builder = this.createImpermanentGraphDatabaseBuilder(creator);
        this.configure(builder, storeDir);
        return builder;
    }

    private TestGraphDatabaseBuilder createImpermanentGraphDatabaseBuilder(GraphDatabaseBuilder.DatabaseCreator creator) {
        return new TestGraphDatabaseBuilder(creator);
    }

    protected GraphDatabaseService newEmbeddedDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestGraphDatabaseFacadeFactory(this.getCurrentState()).newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)dependencies));
    }

    protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(@Nonnull Config config) {
                return new TestGraphDatabaseFacadeFactory(state, true).newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
            }
        };
    }

    public static class TestGraphDatabaseFacadeFactory
    extends GraphDatabaseFacadeFactory {
        private final TestGraphDatabaseFactoryState state;
        private final boolean impermanent;

        protected TestGraphDatabaseFacadeFactory(TestGraphDatabaseFactoryState state, boolean impermanent) {
            this(state, impermanent, DatabaseInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected TestGraphDatabaseFacadeFactory(TestGraphDatabaseFactoryState state, boolean impermanent, DatabaseInfo databaseInfo, Function<PlatformModule, AbstractEditionModule> editionFactory) {
            super(databaseInfo, editionFactory);
            this.state = state;
            this.impermanent = impermanent;
        }

        TestGraphDatabaseFacadeFactory(TestGraphDatabaseFactoryState state) {
            this(state, false);
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            File absoluteStoreDir = storeDir.getAbsoluteFile();
            File databasesRoot = absoluteStoreDir.getParentFile();
            config.augment(GraphDatabaseSettings.ephemeral, "false");
            config.augment(GraphDatabaseSettings.active_database, absoluteStoreDir.getName());
            config.augment(GraphDatabaseSettings.databases_root_path, databasesRoot.getAbsolutePath());
            if (this.impermanent) {
                config.augment(GraphDatabaseSettings.ephemeral, "true");
                return new ImpermanentTestDatabasePlatformModule(databasesRoot, config, dependencies, this.databaseInfo);
            }
            return new TestDatabasePlatformModule(databasesRoot, config, dependencies, this.databaseInfo);
        }

        private class ImpermanentTestDatabasePlatformModule
        extends TestDatabasePlatformModule {
            ImpermanentTestDatabasePlatformModule(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, DatabaseInfo databaseInfo) {
                super(storeDir, config, dependencies, databaseInfo);
            }

            @Override
            protected FileSystemAbstraction createNewFileSystem() {
                return new EphemeralFileSystemAbstraction();
            }

            protected StoreLocker createStoreLocker() {
                return new StoreLocker(this.fileSystem, this.storeLayout);
            }
        }

        class TestDatabasePlatformModule
        extends PlatformModule {
            TestDatabasePlatformModule(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, DatabaseInfo databaseInfo) {
                super(storeDir, config, databaseInfo, dependencies);
            }

            protected FileSystemAbstraction createFileSystemAbstraction() {
                FileSystemAbstraction fs = TestGraphDatabaseFacadeFactory.this.state.getFileSystem();
                if (fs != null) {
                    return fs;
                }
                return this.createNewFileSystem();
            }

            protected FileSystemAbstraction createNewFileSystem() {
                return super.createFileSystemAbstraction();
            }

            protected LogService createLogService(LogProvider userLogProvider) {
                LogProvider internalLogProvider = TestGraphDatabaseFacadeFactory.this.state.getInternalLogProvider();
                if (internalLogProvider == null) {
                    if (!TestGraphDatabaseFacadeFactory.this.impermanent) {
                        return super.createLogService(userLogProvider);
                    }
                    internalLogProvider = NullLogProvider.getInstance();
                }
                return new SimpleLogService(userLogProvider, internalLogProvider);
            }

            protected SystemNanoClock createClock() {
                SystemNanoClock clock = TestGraphDatabaseFacadeFactory.this.state.clock();
                return clock != null ? clock : super.createClock();
            }
        }
    }
}

