/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.CommunityEditionModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.test.TestGraphDatabaseFactory;

public class AdversarialPageCacheGraphDatabaseFactory {
    private AdversarialPageCacheGraphDatabaseFactory() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static GraphDatabaseFactory create(final FileSystemAbstraction fs, final Adversary adversary) {
        return new TestGraphDatabaseFactory(){

            @Override
            protected GraphDatabaseService newEmbeddedDatabase(File dir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

                    protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                        File absoluteStoreDir = storeDir.getAbsoluteFile();
                        File databasesRoot = absoluteStoreDir.getParentFile();
                        config.augment(GraphDatabaseSettings.active_database, absoluteStoreDir.getName());
                        config.augment(GraphDatabaseSettings.databases_root_path, databasesRoot.getAbsolutePath());
                        return new PlatformModule(databasesRoot, config, this.databaseInfo, dependencies){

                            protected FileSystemAbstraction createFileSystemAbstraction() {
                                return fs;
                            }

                            protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, VersionContextSupplier versionContextSupplier) {
                                PageCache pageCache = super.createPageCache(fileSystem, config, logging, tracers, versionContextSupplier);
                                return new AdversarialPageCache(pageCache, adversary);
                            }
                        };
                    }
                }.newFacade(dir, config, dependencies);
            }
        };
    }
}

